<?php

namespace App\Http\Controllers\Admin;

use App\Models\Bank;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\BankRequest;
use Illuminate\Http\Request;
use Image;

class BankController extends Controller
{
    public function index()
    {
        $this->authorize('view_banks', Bank::class);
        $data = Bank::orderBy('id', 'DESC')->paginate(10);

        return view('admin.banks.index', compact('data'));
    }

    public function show(Bank $bank)
    {
        $this->authorize('show_banks', $bank);

        return view('admin.banks.show', compact('bank'));
    }



    public function create()
    {
        $this->authorize('create_banks', Bank::class);

        return view('admin.banks.create');
    }

    public function store(BankRequest $request) {

        $this->authorize('create_banks', Bank::class);


        if ( isset($request->photo) && $request->photo ){
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $request['height']=$height;
            $request['width']=$width;
            $request['image'] = UploadImage($request->file('photo'), 'banks', '/uploads/banks');

        }


        $data = Bank::create($request->all());

        return $data ?
            redirect()->route('admin.banks.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.banks.index')->with('warning', trans('messages.addNO'));
    }

    public function edit(Bank $bank) {

        $this->authorize('edit_banks', $bank);
        return view('admin.banks.edit', compact('bank'));
    }

    public function update(BankRequest $request, Bank $bank) {

        $this->authorize('edit_banks', $bank);


        if ( isset($request->photo) && $request->photo ){
            @unlink(public_path('uploads/banks/') . $bank->image);
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $request['height']=$height;
            $request['width']=$width;
            $request['image'] = UploadImage($request->file('photo'), 'banks', '/uploads/banks');

        }

        $data = $bank->update($request->all());

        return $data ?
            redirect()->route('admin.banks.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.banks.index')->with('warning', trans('messages.updateNO'));
    }


    public function destroy(Request $request) {

        $data = Bank::find($request->id);
        if (isset($data->image) && $data->image != '') {
            @unlink(public_path('uploads/banks/') . $data->image);
        }
        $deleted = $data->delete();

        $url = route('admin.banks.index');

        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
}
