<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\OrderTransfer;
use Illuminate\Http\Request;

class BankTransferController extends Controller
{
    //order_transfers
    public function index( )
    {
        $this->authorize('view_order_transfers', OrderTransfer::class);
        $data = OrderTransfer::orderBy('id', 'DESC')->where('status',\request()->type)->paginate(10);
        if (\request()->type == "approved"){
            return view('admin.banksTransfer.approved', compact('data'));
        }
        elseif (\request()->type == "refuse"){
            return view('admin.banksTransfer.refuse', compact('data'));
        }else{
            return view('admin.banksTransfer.index', compact('data'));
        }


    }

    public function confirm_transfer(Request $request) {

        $data = OrderTransfer::find($request->id);

        $data->update(['status'=>"approved"]);


        $url = route('admin.banksTransfer.index','type=approved');


        return $data
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
    public function dont_transfer(Request $request) {

        $data = OrderTransfer::find($request->id);
        $order = Order::find($data->order_id);

        $data->update(['status'=>"refuse"]);

        $url = route('admin.banksTransfer.index','type=refuse');


        return $order
            ? json_encode(['code' => '1', 'url' => $url ])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
}
