<?php

namespace App\Http\Controllers\Admin;


use App\Http\Requests\Admin\CouponRequest;
use App\Jobs\SendMailJob;
use App\Mail\CouponSend;

use App\Models\Coupon;
use App\Models\User;
use App\Models\UserCoupon;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;

class CouponsController extends Controller
{
    public function index()
    {
        $this->authorize('view_coupons', Coupon::class);
        $data = Coupon::where('to_date','>=',Carbon::now()->format('Y-m-d'))->orderBy('id', 'DESC')->paginate(10);

        return view('admin.coupons.index', compact('data'));
    }
    public function expired_coupons()
    {
        $this->authorize('view_coupons', Coupon::class);
        $data = Coupon::where('to_date','<',Carbon::now()->format('Y-m-d'))->orWhere('available_number',0)->orderBy('id', 'DESC')->paginate(10);

        return view('admin.coupons.expired_coupons', compact('data'));
    }

    public function create()
    {
        $this->authorize('create_coupons', Coupon::class);
        $users = User::where('user_type','user')->get();
        return view('admin.coupons.create',compact('users'));
    }

    public function store(CouponRequest $request) {

        $this->authorize('create_coupons', Coupon::class);

        if (in_array('all',$request->user_id)){
            $request['shared']=1;
            $data = Coupon::create($request->all());
        }else{
            $data = Coupon::create($request->all());
        }


            foreach ($request->user_id as $user){

                if ($user == "all"){

                    if ($request->send_email == "send") {
                        $job = (new SendMailJob($data))
                            ->delay(Carbon::now()->addSeconds(5));
                        $this->dispatch($job);
                    }
                    return $data ?
                        redirect()->route('admin.coupons.index')->with('success', trans('messages.updateOK')) :
                        redirect()->route('admin.coupons.index')->with('warning', trans('messages.updateNO'));

                }else{


                    UserCoupon::create([
                        'user_id'=>$user,
                        'coupon_id'=>$data->id,
                    ]);
                    $result = filter_var( User::find($user)->email, FILTER_VALIDATE_EMAIL );
                    if ($result){
                        $emailArray = explode("@", User::find($user)->email);

                        if (checkdnsrr(array_pop($emailArray), "MX")) {
                            if ($request->send_email == "send") {
                                if (User::find($user)->email) {
                                    $this->sendEmail(User::find($user)->email, $data->code, $data->from_date, $data->to_date, $data->available_number);
                                }
                            }
                        }

                    }


                }

            }




        return $data ?
            redirect()->route('admin.coupons.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.coupons.index')->with('warning', trans('messages.addNO'));
    }
    public function edit(Coupon $coupon) {

        $this->authorize('edit_coupons', $coupon);
        $users = User::where('user_type','user')->get();
        return view('admin.coupons.edit', compact('coupon','users'));
    }

    public function update(CouponRequest $request, Coupon $coupon) {

        $this->authorize('edit_coupons', $coupon);




        foreach ($request->user_id as $user){

            if ($user == "all"){
                $request['shared']=1;
                $data = $coupon->update($request->all());
                if ($request->send_email == "send"){
                    $job = (new SendMailJob($coupon))
                        ->delay(Carbon::now()->addSeconds(5));
                    $this->dispatch($job);
                }
                    return $data ?
                        redirect()->route('admin.coupons.index')->with('success', trans('messages.updateOK')) :
                        redirect()->route('admin.coupons.index')->with('warning', trans('messages.updateNO'));


            }else{
                $request['shared']=0;
                $data = $coupon->update($request->all());

                    if (! UserCoupon::where('coupon_id',$coupon->id)->where('user_id',$user)->first()){
                        UserCoupon::create([
                            'user_id'=>$user,
                            'coupon_id'=>$coupon->id,
                        ]);
                    }
                $result = filter_var( User::find($user)->email, FILTER_VALIDATE_EMAIL );
                if ($result){
                    $emailArray = explode("@", User::find($user)->email);

                    if (checkdnsrr(array_pop($emailArray), "MX")) {
                        if ($request->send_email == "send"){
                            if (User::find($user)->email) {
                                $this->sendEmail(User::find($user)->email, $coupon->code, $coupon->from_date, $coupon->to_date, $coupon->available_number);
                            }
                        }
                    }

                }


            }

        }




        return $data ?
            redirect()->route('admin.coupons.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.coupons.index')->with('warning', trans('messages.updateNO'));
    }
    protected function sendEmail($userEmail, $code, $from_date, $to_date,$number) {

        $data = [
            'code'  => $code,
            'from_date'       => $from_date,
            'to_date'   => $to_date,
            'number'   => $number,
        ];

        Mail::to($userEmail)->send(new CouponSend($data));

        if( count(Mail::failures()) > 0 ) {
            Mail::to($userEmail)->send(new CouponSend($data));

            if( count(Mail::failures()) > 0 ) {
                Mail::to($userEmail)->send(new CouponSend($data));
            }
        }
    }


    public function changeStatus(Request $request){

        $updated = Coupon::where('id', $request->id)->update(['status' => $request->status]);
        $url = route('admin.coupons.index');

        return $updated
            ? json_encode(['code'=> '1', 'url'=> $url])
            : json_encode(['code'=> '0', 'message'=> 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }


    public function destroy(Request $request) {

        $data = Coupon::find($request->id);

        //check-if-user has coupon
//        if( $data->users()->count() > 0)
//            return json_encode(['code' => '2', 'message' => trans('messages.cant_delete')]);



        $deleted = $data->delete();
        $url = route('admin.coupons.index');

        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
}
