<?php

namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Api\ApiController;
use App\Mail\CouponSend;
use App\Mail\OrderSend;
use App\Models\Order;
use App\Models\OrderProduct;
use App\Models\OrderTransfer;
use App\Models\PaymentMethod;
use App\Models\Product;
use App\Models\Setting;
use App\Models\UserDevice;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;

class OrderController extends Controller
{
    //
    public function index($type,$status){
        $this->authorize('view_orders', Order::class);
        $typeTitle      = $this->getOrderType($status);


        $data = Order::where('status', $status)->orderBy('id', 'DESC')->paginate(10);

        return view('admin.orders.' . $status, compact(  'status', 'type', 'typeTitle', 'data'));
    }

    public function show(Order $order)
    {
        $this->authorize('show_orders', $order);

        $title      = $this->getOrderType($order->status);
        $user = User::find($order->user_id);
        $data= $order->products()->get();

        return view('admin.orders.show', compact('order','title','data','order','user'));
    }
    public function orders_details(Order $order)
    {
        $this->authorize('show_orders', $order);

        $title      = $this->getOrderType($order->status);
        $user = User::find($order->user_id);
        $data= $order->products()->get();

        return view('admin.orders.orders_details', compact('order','title','data','order','user'));
    }

    public function change_status_order(Order $order) {

        $this->authorize('activate_orders', Order::class);
        $user = User::find($order->user_id);

        return view('admin.orders.change_status_orders', compact('order','user'));
    }
    public function change_status_order_update(Request $request ,Order $order) {

        $this->authorize('activate_orders', Order::class);
        $this->validate($request, [
            'status'  => 'required',
        ]);
        if ($request->status !== $order->status){
            if ($order->status == "in_progress"){

                $order->update(['status'=>"done"]);
                if (PaymentMethod::find($order->payment_method)->type == "visa"||
                    PaymentMethod::find($order->payment_method)->type == "transfer"){
                    $product = OrderProduct::whereOrderId($order->id)->first()->product_id;
                    $user = User::find(Product::find($product)->user_id);
                    $total =  $order->all_total - ($order->all_total * $user->app_percentage /100);
                    $user->update(['wallet'=>$user->wallet + $total]);
                }
            }elseif ($order->status == "new"){
                $type=PaymentMethod::find($order->payment_method);
                if ($type->type == "transfer"){
                    if (OrderTransfer::whereOrderId($order->id)->first()){
                        if (OrderTransfer::whereOrderId($order->id)->first()->status == "waiting" ||
                            OrderTransfer::whereOrderId($order->id)->first()->status == "refuse"){
                            return back()->withInput()->with('warning',"لا يمكنك تغيير حالة الطلب حتى توافق علي التحويل البنكي");
                        }
                    }else{
                        return back()->withInput()->with('warning',"لا يمكنك تغيير حالة الطلب حتى توافق علي التحويل البنكي");
                    }

                }
                $order->update(['status'=>"in_progress"]);
            }
            /*send notifications*/
            $notificationTitle = array(
                'ar'=>$this->getOrderTypeStatus($request->status,'ar'),
                'en'=>$this->getOrderTypeStatus($request->status,'en'),
            );
            $notificationMessage = array(
                'ar'=>$this->getOrderTypeSecondEnglish($request->status,$order->id,'ar'),
                'en'=>$this->getOrderTypeSecondEnglish($request->status,$order->id,'en'),

            );
            $all_data = array(
                'title'=>$this->getOrderTypeStatus($request->status,'ar'),
                'body'=>$this->getOrderTypeSecondEnglish($request->status,$order->id,'ar'),
                'type'=>3,
                'seen'=>0,
                'notifiable_id'=>$order->id,
            );

            $devicesTokens  = UserDevice::where('user_id', $order->user_id)
//                ->where('is_open', true)
                ->orderBy('updated_at', 'DESC')
                ->pluck('firebase_token')
                ->toArray();

            saveOrderNotification($order->user_id, 3, serialize($notificationTitle) , serialize($notificationMessage) ,$order->id ,'App\Order' );
            if($devicesTokens)
                sendMultiNotification($all_data, $devicesTokens);
            /*end notifications*/
        }
        $data = $order->update($request->all());


        return $data ?
            redirect()->route('admin.orders.index',['order',$order->status])->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.orders.index',['order',$order->status])->with('warning', trans('messages.updateNO'));
    }
    function getOrderType($type)
    {
        switch ($type) {
            case 'new':
                return trans('web.Underway');
            case 'ready_ship':
                return trans('web.Ready_to_ship');
            case 'in_progress':
                return trans('web.in_progress');
            case 'cancel_order':
                return trans('web.cancel_order');
            case 'in_shipping':
                return trans('web.in_shipping');
            case 'done':
                return trans('web.done');
            default:
                return null;
        }
    }
    function getOrderTypeStatus($type,$lang)
    {


        switch ($type) {
            case 'new':
                return $lang == 'ar' ?  "قيد المراجعة" : "Preparation" ;
            case 'in_progress':
                return $lang == 'en' ? "In progress" : "جاري التجهيز";
            case 'cancel_order':
                return $lang == 'en' ? "Cancel order" : "ملغي";
            case 'done':
                return $lang == 'en
                ' ? "Delivered" : "تم استلامها";
            default:
                return null;
        }
    }


    function getOrderTypeSecondEnglish($type ,$order,$lang)
    {

        switch ($type) {
            case 'new':
                return "طلبك جاري ".$order." التجهيز";
            case 'in_progress':
                return "شكرا لك على طلبك من نسق 🌹، طلبك الأن جاهز";
            case 'cancel_order':
                return "لقد قمت بإلغاء طلبك ".$order." لدينا";
            case 'done':
                return "تهانينا 🥳، لقد استلمت طلبك رقم".$order;
            default:
                return null;
        }
    }
    protected function sendEmail($userEmail, $status,$status_text, $url,$first,$second,$order,$lang) {

        $data = [
            'status'  => $status,
            'url'       => $url,
            'lang'       => $lang,
            'order_id'       => $order,
            'first'       => $first,
            'second'       => $second,
            'status_text'       => $status_text,
        ];

        Mail::to($userEmail)->send(new OrderSend($data));

        if( count(Mail::failures()) > 0 ) {
            Mail::to($userEmail)->send(new OrderSend($data));

            if( count(Mail::failures()) > 0 ) {
                Mail::to($userEmail)->send(new OrderSend($data));
            }
        }
    }


}
