<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\PaymentMethodRequest;

use App\Models\PaymentMethod;
use Illuminate\Http\Request;
use Image;

class PaymentMethodController extends Controller
{
    public function index()
    {
        $this->authorize('view_payment_methods', PaymentMethod::class);
        $data = PaymentMethod::orderBy('id', 'DESC')->paginate(10);

        return view('admin.payment_methods.index', compact('data'));
    }


    public function create()
    {
        $this->authorize('create_payment_methods', PaymentMethod::class);
        return view('admin.payment_methods.create');
    }

    public function store(PaymentMethodRequest $request) {

        $this->authorize('create_payment_methods', PaymentMethod::class);

        $request['country_id']=1;
        if ( isset($request->photo) && $request->photo ){
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $request['height']=$height;
            $request['width']=$width;
            $request['icon'] = UploadImage($request->file('photo'), 'paymentMethods', '/uploads/paymentMethods');
//paymentMethods
        }
        $data = PaymentMethod::create($request->all());

        return $data ?
            redirect()->route('admin.payment-methods.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.payment-methods.index')->with('warning', trans('messages.addNO'));
    }

    public function edit(PaymentMethod $paymentMethod) {

        $this->authorize('edit_payment_methods', $paymentMethod);

        return view('admin.payment_methods.edit', compact('paymentMethod'));
    }

    public function update(PaymentMethodRequest $request, PaymentMethod $paymentMethod) {

        $this->authorize('edit_payment_methods', $paymentMethod);

        if ( isset($request->photo) && $request->photo ){
            @unlink(public_path('uploads/paymentMethods/') . $paymentMethod->icon);
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $request['height']=$height;
            $request['width']=$width;
            $request['icon'] = UploadImage($request->file('photo'), 'paymentMethods', '/uploads/paymentMethods');

        }
        $data = $paymentMethod->update($request->all());


        return $data ?
            redirect()->route('admin.payment-methods.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.payment-methods.index')->with('warning', trans('messages.updateNO'));
    }

    public function destroy(Request $request) {

        $data = PaymentMethod::find($request->id);

        if( $data->orders()->count() > 0)
            return json_encode(['code' => '2', 'message' =>trans('messages.cant_delete')]);

        @unlink(public_path('uploads/paymentMethods/') . $data->icon);
        $deleted = $data->delete();
        $url = route('admin.payment-methods.index');

        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }

    public function changeStatus(Request $request){

        $updated = PaymentMethod::where('id', $request->id)->update(['status' => $request->status]);

        $url = route('admin.payment-methods.index');

        return $updated
            ? json_encode(['code'=> '1', 'url'=> $url])
            : json_encode(['code'=> '0', 'message'=> 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
}
