<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\RoleRequest;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class RoleController extends Controller
{

    public function index(){

        $this->authorize('view_roles', Role::class);
        $data = Role::orderBy('id', 'DESC')->get();

        return view('admin.roles.index', compact('data'));
    }

    public function create(){

        $this->authorize('create_roles', Role::class);
        $allPermissions = Permission::orderBy('table_name', 'ASC')->get();
        $data           = $this->getPermissions($allPermissions);

        return view('admin.roles.create', compact('data'));
    }

    public function store(RoleRequest $request){

        $role = Role::create($request->all());
        $role->permissions()->sync($request->permissions);

        return $role ?
            redirect()->route('admin.roles.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.roles.index')->with('warning', trans('messages.addNO'))->withInput();
    }

    public function edit(Role $role){

        if ( $role->id == 1)
            abort('403');

        $this->authorize('edit_roles', $role);
        $allPermissions = Permission::orderBy('table_name', 'ASC')->get();
        $data           = $this->getPermissions($allPermissions);
        $rolePermissions= $role->permissions()->pluck('id')->toArray();

        return view('admin.roles.edit', compact('role', 'data', 'rolePermissions'));
    }

    public function update(RoleRequest $request, Role $role) {

        if ( $role->id == 1)
            abort('403');

        $updated = $role->update($request->all());
        $role->permissions()->sync($request->permissions);

        return $updated ?
            redirect()->route('admin.roles.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.roles.index')->with('warning', trans('messages.updateNO'));
    }

    public function destroy(Request $request){

        $deleted = Role::where('id', $request->id)->delete();
        $url     = route('admin.roles.index');
        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }

    protected function getPermissions($permissions) {

        $data = [];
        foreach ($permissions as $key => $permission) {

            end($data);
            $last_key = key($data);

            if( $key > 0 && count($data) > 0) {

                if( $permission->table_name == key($data[$last_key]) ) {

                    $data[$last_key][$permission->table_name][] = $permission;
                }
                else {
                    array_push( $data, array($permission->table_name => [$permission]) );
                }
            }
            else {
                array_push( $data, array($permission->table_name => [$permission]) );
            }
        }
        return $data;
    }
}
