<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class DealerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if( $this->method() == 'PATCH' ) {

            return [
                'phone' =>['required', 'regex:/(05)[0-9]{8}/','size:10','unique:users,phone,'. $this->dealer->id],
                'name'                  => 'required|max:255',
                'app_percentage'                  => 'required|numeric',
                'email'                  => 'nullable|string|email|max:255|unique:users,email,'.$this->dealer->id,
                'region_id'                  => 'required',
                'city_id'                  => 'required',
            ];
        }
        return [

            'phone' =>['required', 'regex:/(05)[0-9]{8}/','size:10','unique:users'],
            'name'                  => 'required|max:255',
            'email'                  => 'nullable|string|email|max:255|unique:users',
            'password'              => 'required|min:6',
            'app_percentage'                  => 'required|numeric',
            'region_id'                  => 'required',
            'city_id'                  => 'required',
        ];
    }
}
