<?php

namespace App\Http\Resources\User;


use App\Models\Product;
use Illuminate\Http\Resources\Json\JsonResource;

class CartDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {
        if ($this->productable_type == "App\Product"){
            $product =Product::find($this->product_id);
            $title = $product->title[app()->getLocale()];
            $image= $product->images()->first()->image;
        }else{
            $product =Product::find($this->product_id);
            $title = $product->title;
            $image= $product->images()->first()->image;
        }
        $data = [
            'id' => $this->id,
            'product_id' => $this->product_id,
            'image_path'=>'/uploads/products/',
            'image' =>$image,
            'title'=>$title,
            'total' =>$this->total,

        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
