<?php

namespace App\Http\Resources\User;


use App\Http\Resources\OrderProductDetailsResource;
use App\Models\OrderProduct;
use App\Models\PaymentMethod;
use App\Models\Room;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {

        $data= [
            'id' => $this->id,
            'payment_method' => PaymentMethod::find($this->payment_method)->name[app()->getLocale()],
            'status'=> getOrderType($this->status),
            'status_id'=> $this->status,
            'order_date'=> Carbon::parse($this->created_at)->isoFormat('MMMM Do YYYY, hh:mm a'),
            'created_at'=> $this->created_at,
            'address' => [
                'name'=>$this->name,
                'phone'=>$this->phone,
                'notes'=>$this->notes,
                'city_name'=>$this->city->name[app()->getLocale()],
                'region_name'=>$this->region->name[app()->getLocale()],

            ],
            'orders' => OrderProductDetailsResource::collection(OrderProduct::whereOrderId($this->id)->get()),
            'coupon'=>$this->coupon,
            'products_total'=>$this->products_total,
            'shipping_cost'=>$this->shipping_cost,
            'total_after_coupon'=>$this->total_after_coupon,
            'all_total'=> $this->all_total ,
            'delivered'=>$this->status == "done" ? 1 : 0,
            'whatsapp_numbner'=>settings()->whatsapp,
            'room_id'=>Room::whereSenderId($request->user()->id)
                ->orWhere('receiver_id',$request->user()->id)->first() ? Room::whereSenderId($request->user()->id)
                ->orWhere('receiver_id',$request->user()->id)->first()->id : null,
        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
