<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Resources\Json\JsonResource;

class PostResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {


        $data= [
            'id'  => $this->id,
            'description'  => $this->description,
            'user'  => [
                'id'=>$this->user_id,
                'name'=>$this->user->name,
                'image_path'=>'/uploads/users/',
                'image'=>$this->user->image,
                'height' => $this->user->height,
                'width' => $this->user->width,
            ],
            'image_path'=>'/uploads/posts/',
            'image'=>$this->image,
            'height'=>$this->height,
            'width'=>$this->width,
            'open_comments'=>$this->open_comments,
            'created_at'=>$this->created_at->format('d/m/y'),
        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
