<?php

namespace App\Http\Resources\User;

use App\Models\Post;
use App\Models\ProductRate;
use Illuminate\Http\Resources\Json\JsonResource;

class ProviderProfileResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {

      $posts =  Post::whereUserId($this->id)->paginate(10);
        PostResource::collection($posts);
        $data= [
            'id' => $this->id,
            'image_path'=>'/uploads/users/',
            'image' =>$this->image,
            'height' => $this->height,
            'width' => $this->width,
            'name' =>$this->name,
            'description'                 => $this->description,
            'rates'=>(int) ProductRate::where('to_user',$this->id)->avg('rate'),
            'posts'=>$posts,
            'rates_total'=>(int) ProductRate::where('to_user',$this->id)->count(),
        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
