<?php

namespace App\Http\Resources\User;


use Illuminate\Http\Resources\Json\JsonResource;

class SubCategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {

        $data= [
            'id' => $this->id,
            'name'  => $this->name[app()->getLocale()],
            'image_path'=>'/uploads/categories/',
            'image' => $this->image,
            'height' => $this->height,
            'width' => $this->width,
        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
