<?php


use App\AdminNotification;
use App\Mail\Notification;
use App\Models\Employee;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Kreait\Firebase\Factory;
use Kreait\Firebase\ServiceAccount;
use Tymon\JWTAuth\Facades\JWTAuth;
use Edujugon\PushNotification\PushNotification;
//use FCM;

function settings() {

    return  \App\Models\Setting::where( 'id', 1 )->first();
}
function explodeByComma( $str ) {
    return explode( ",", $str );
}

function explodeByDash( $str ) {
    return explode( "-", $str );
}
function array_flatten( $arr, $out=array() )  {
    foreach( $arr as $item ) {
        if ( is_array( $item ) ) {
            $out = array_merge( $out, array_flatten( $item ) );
        } else {
            $out[] = $item;
        }
    }
    return $out;
}
function explodeByUnderscore( $str ) {
    return explode( "_", $str );
}
function OrderRatingsStars($rate)
{
    $str = '';
    for ($i = 0; $i < 5; $i++) {
        if ($rate >= $i+1)
            $str .= '<i class="fa fa-star" style="color: #f0c411;"></i>';
        else
            $str .= '<i class="fa fa-star" style="color: #d8d6cf;"></i>';
    }
    return $str;
}

function validateRules($errors, $rules) {
    $error_arr = "";
    foreach ($rules as $key => $value) {
        if( $errors->get($key) ) {
            $error_arr .= $errors->first($key). " \n ";
        }
    }

    return $error_arr;
}
function randNumber($length) {

    $seed = str_split('0123456789');

    shuffle($seed);

    $rand = '';

    foreach (array_rand($seed, $length) as $k) $rand .= $seed[$k];

    return $rand;
}

function generateApiToken($userId) {

    $myTTL = 60 * 60 * 365; //minutes
    JWTAuth::factory()->setTTL($myTTL);
    $token = JWTAuth::fromUser($userId);

    return $token;
}


function UploadImage( $inputRequest, $prefix, $folderNam ) {


        $imageName = $prefix . '_' . time().randNumber(4) .'.' . $inputRequest->getClientOriginalExtension();

        $destinationPath = public_path( '/' . $folderNam );

        $inputRequest->move( $destinationPath, $imageName );

        return $imageName ? $imageName : false;


}
function UploadAudio( $inputRequest, $prefix, $folderNam ) {

    $imageName = $prefix . '_' . time().randNumber(4) .'.m4a';

    $destinationPath = public_path( '/' . $folderNam );

    $inputRequest->move( $destinationPath, $imageName );
    $audio_path = public_path( '/' . $folderNam ) . '/' . $imageName;
    exec("ffmpeg -i ".$audio_path." -acodec libmp3lame -ab 32k -ac 1 -ar 11025 ".$audio_path."");
    return $imageName ? $imageName : false;
}
function UploadImageEdit( $inputRequest, $prefix, $folderNam, $oldImage ) {
    @unlink(public_path('/'.$folderNam.'/'.$oldImage));
    $imageName = $prefix . '_' . time().randNumber(4) .'.' . $inputRequest->getClientOriginalExtension();

    $destinationPath = public_path( '/' . $folderNam );

    $inputRequest->move( $destinationPath, $imageName );

    return $imageName ? $imageName : false;
}


function getAvgOneRaw($ratingRow)
{
    $sum = $ratingRow->quality_stars + $ratingRow->delivery_stars + $ratingRow->packaging_stars + $ratingRow->price_stars;

    return $sum / 4;
}



function unReadMessagesCount() {

    return \App\Models\Contact::whereIsRead(false)->count();
}
function WaitingAcceptEmployeeCount() {

    return \App\Models\Employee::whereAccepted(false)->count();
}
function AcceptEmployeeCount() {

    return \App\Models\Employee::whereAccepted(true)->count();
}


function siteLanguages()
{
    return [
        'ar' => 'عربي',
        'en' => 'English',
    ];
}

function getOrderType($type)
{
    switch ($type) {
        case 'new':
            return trans('web.Underway');
        case 'in_progress':
            return trans('web.in_progress');
        case 'cancel_order':
            return trans('web.cancel_text_order');
        case 'done':
            return trans('web.done');
        default:
            return null;
    }
}
function getWalletStatus($type)
{
    switch ($type) {
        case 'waiting':
            return trans('web.waiting');
        case 'approved':
            return trans('web.approved');
        case 'refused':
            return trans('web.refused');
        default:
            return null;
    }
}


function getLinkType($type)
{
    switch ($type) {
        case 'product':
            return 'منتج';
        case 'category':
            return 'قسم';
        case 'external_link':
            return 'رابط خارجي';
        case 'just_ads':
            return 'اعلان مجرد';
        default:
            return null;
    }
}



function checkPermissionExists($id, $permissionsIds) {

    return in_array($id, $permissionsIds);
}

function userRatingsStars($rate)
{
    $str = '';
    for ($i = 0; $i < 5; $i++) {
        if ($rate >= $i+1)
            $str .= '<i class="fa fa-star" style="color: #f0c411;"></i>';
        else
            $str .= '<i class="fa fa-star" style="color: #d8d6cf;"></i>';
    }
    return $str;
}

function notificationShortcutTypes(){

    return [
        '1' => 'admin',
        '2' => 'new product',
        '3' => 'change status of product',
        '4' => 'send message in chat',
        '5' => 'confirm pull request',
        '6' => 'activation account (register for dealer)',

    ];
}


function getAdminOrderTypeCount($statusArr)
{
    return \App\Models\Order::whereStatus($statusArr)->count();
}



function sendEmailForUser($userEmail, $message, $headingTitle) {

    $data = [
        'title'   => $headingTitle,
        'message'          => $message,
        'messagesTitle' => "Cine",
    ];


    Mail::to($userEmail)->send(new Notification($data));

    if( count(Mail::failures()) > 0 ) {
        Mail::to($userEmail)->send(new Notification($data));

        if( count(Mail::failures()) > 0 ) {
            Mail::to($userEmail)->send(new Notification($data));
        }
    }
}


function sendChatMobileNotification($userId ,$from , $title, $message ,$type,$dataId) {
    $devicesTokens = \App\Models\UserDevice::where('user_id', $userId)
//        ->where('is_open',1)
        ->get()
        ->pluck('firebase_token')
        ->toArray();
    $all_data = array(
        'title'=>$title[\App\Models\User::find($userId)->language],
        'body'=>$message[\App\Models\User::find($userId)->language],
        'type'=>$type,
        'targetUserName'=>\App\Models\User::find($from)->name ,
        'targetUserId'=>$from ,
        'targetUserImage'=>url('/').'/uploads/users/'.\App\Models\User::find($from)->image ,
        'seen'=>0,
        'room_id'=>$dataId,
//        'click_action' => 'MAIN_ACTIVITY',
        'sound' => true,
    );
    if (count($devicesTokens) > 0){
        sendNote($devicesTokens,$message[\App\Models\User::find($userId)->language] ,$all_data);

    }


}
function sendNote($tokens = [], $contents, $data = [])
{
    //FCM api URL
    $url = 'https://fcm.googleapis.com/fcm/send';
    //api_key available in Firebase Console -> Project Settings -> CLOUD MESSAGING -> Server key
    $server_key = 'AAAAA4Qj1Ng:APA91bEvQQBsm61YmllIN5PngOIToLBeFMrUSQw3kmKIIoGev2wN9VuYOtVgJKv0nd2O-XFRSLajv0Y0cgYgPsG1gW_C9I6rRw4e5cHfyBUNQXZJCqVWdSl4ILcDXSqhJ-w27KXJwSz4';

    //header with content_type api key
    $headers = array(
        'Content-Type:application/json; charset=utf-8',
        'Authorization:key='.$server_key
    );

    $extraNotificationData = $data;

    $fields = [
        'registration_ids' => $tokens, //multple token array
        'notification' => $data,
        'data' => $extraNotificationData
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    $result = curl_exec($ch);
    curl_close($ch);

    return $result;
}
function sendMobileNotification($userId , $title, $message ,$type,$dataId) {
    $devicesTokens = \App\Models\UserDevice::where('user_id', $userId)
//         ->where('is_open',1)
        ->get()
        ->pluck('firebase_token')
        ->toArray();
    $all_data = array(
        'title'=>$title[\App\Models\User::find($userId)->language],
        'body'=>$message[\App\Models\User::find($userId)->language],
        'type'=>$type,
        'seen'=>0,
        'notifiable_id'=>$dataId,
        'sound' => 'default',
//         'click_action' => 'FCM_PLUGIN_ACTIVITY',
    );
    if ($devicesTokens)
        sendMultiNotification($all_data ,$devicesTokens);

}
function sendTopicNotification($all_data,$topicType) {
    $msg = [
        'data' => $all_data,
        'notification' => $all_data,
        'priority' => 'high',
    ];

    $push = new PushNotification('fcm');
    $response = $push->setMessage($msg)
//        ->setApiKey('YOUR-API-KEY')
        ->setConfig(['dry_run' => false])
        ->sendByTopic($topicType);
}
function sendMultiNotification($all_data, $devicesTokens) {

    $msg = [
        'data' => $all_data,
        'notification' => $all_data,
        'priority' => 'high',
    ];
    $push = new PushNotification('fcm');
    $push->setMessage($msg)
        ->setDevicesToken($devicesTokens)
        ->send();

}

function saveNotification($userId, $type, $title, $message) {

    $created = \App\Models\Notification::create(['user_id'=> $userId, 'type'=> $type, 'title'=> $title, 'message'=> $message]);
    return $created;
}

function saveOrderNotification($userId, $type, $title, $message,$notifiableId,$notifiableType) {

    $created = \App\Models\Notification::create(['user_id'=> $userId, 'type'=> $type, 'title'=> $title, 'message'=> $message ,'notifiable_id'=>$notifiableId,'notifiable_type'=>$notifiableType]);
    return $created;
}




