<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class CouponSend extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data         = $data;
        $this->siteName     = "info@nosq.app";
        $this->siteEmail    = settings()->email;
        $this->sitePhone    = settings()->phone;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from(settings()->email, "info@nosq.app" )
            ->view('emails.coupon')
            ->subject("Coupon")
            ->with([
                'code'  => $this->data['code'],
                'from_date'   => $this->data['from_date'],
                'to_date'   => $this->data['to_date'],
                'number'   => $this->data['number'],
                'siteName'      => $this->siteName,
                'siteEmail'     => $this->siteEmail,
                'sitePhone'     => $this->sitePhone,
            ]);
    }
}
