<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Region extends Model
{
    use HasFactory;
    protected $fillable=['parent_id', 'name', 'shipping_cost'];
    protected $casts=['name'=>"json"];

    public function users() {
        return $this->belongsToMany(User::class)->withTimestamps();
    }
    public function regions() {
        return $this->hasMany(Region::class,'parent_id');
    }
    public function city() {
        return $this->belongsTo(Region::class,'parent_id');
    }

}
