<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Permission;
use App\Models\Role;
use App\Models\Admin;

class CreateCategoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('parent_id')->unsigned()->nullable();
            $table->longText('name');
            $table->string('image')->nullable();

            $table->foreign('parent_id')
                ->references('id')->on('categories')
                ->onDelete('cascade');
            $table->timestamps();
        });
        //****************************************************//
        //**************** CREATE-PERMISSIONS ****************//
        //****************************************************//

        //generate-permissions-for-this-table..
        Permission::generatePermissions('categories');

        //add-these-permissions-to-admin-role(first_one)..
        $adminRole = Role::where('id', 1)->first();
        $adminRole->permissions()->sync( Permission::all()->pluck('id') );

        //add-these-permissions-to-admin-user..
        Admin::where('id', 1)->first()->permissions()->sync( Permission::all()->pluck('id') );
        //****************************************************//
        //***************** END-PERMISSIONS ******************//
        //****************************************************//
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('categories');
    }
}
