<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChatsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('chats', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('sender_id')->unsigned()->nullable();
            $table->string('senderable_type')->nullable();
            $table->bigInteger('room_id')->unsigned()->nullable();
            $table->bigInteger('gift_id')->unsigned()->nullable();
            $table->string('giftable_type')->nullable();
            $table->longText('message')->nullable();
            $table->string('file')->nullable();
            $table->boolean('seen')->default(false);
            $table->boolean('duration')->default(false);
            $table->enum('type',['file','image','text','voice','gift'])->nullable();


            $table->foreign('room_id')
                ->references('id')->on('rooms')
                ->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('chats');
    }
}
