$(document).ready(function() {

    function saveLocation(result, latValue, lngValue) {

        var i;
        var placeId;
        var flag = '0';

        $('#address_level_3').val('');
        $('#address_level_2').val('');
        $('#address_level_1').val('');

        $('#lat').val(latValue);
        $('#lng').val(lngValue);

        for (i=0; i<result.length; i++) {

            placeId = result[i].place_id;

            if (result[i].types[0] == 'administrative_area_level_3') {

                $('#address_level_3').val(placeId);
                flag = '1';
            }
            else if (result[i].types[0] == 'administrative_area_level_2') {

                $('#address_level_2').val(placeId);
                flag = '1';
            }
            else if (result[i].types[0] == 'administrative_area_level_1') {

                $('#address_level_1').val(placeId);
                flag = '1';
            }
        }

        if (flag == '0') {

            $('#address_level_3').val(result[0].place_id);
        }
    }


    var marker;
    var map;
    var lat_val;
    var lng_val;

    var lat     = $('#lat').val();
    var long    = $('#lng').val();

    if (lat !== '' && long !== '') {
        lat_val = parseFloat(lat);
        lng_val = parseFloat(long);
    }
    else {
        lat_val = 24.710374406523634;
        lng_val = 46.682441104815666;
    }

    var pos = {lat: lat_val, lng: lng_val};
    var geocoder = new google.maps.Geocoder;

    geocoder.geocode({ 'latLng': pos }, function (results, status) {
        if (status === 'OK') {
            $("#map_address").val(results[1].formatted_address);

        }
    });



    $("#map_address").geocomplete({});

    $("#map_address").change(function() {
        if(marker){
            marker.setMap(null);
        }
    });

    $('a[href="#tab_map"]').on('click', function() {

        setTimeout(function(){

            map = new google.maps.Map(document.getElementById('div_map'), {
                zoom: 14,
                center: pos
            });
            marker = new google.maps.Marker({
                draggable: true,
                position: pos,
                map: map
            });

            $("body").on('change', '#map_address', function () {
                var address=$(this).val();
                if(address!=''){
                    geocoder.geocode({'address': address}, function (results, status) {
                        if (status === 'OK') {

                            // console.log('address complete');
                            // console.log(results);


                            if(marker){
                                marker.setMap(null);
                            }
                            lat = results[0].geometry.location.lat();
                            lng = results[0].geometry.location.lng();
                            var latlng = {lat: lat, lng: lng};

                            saveLocation(results, lat, lng);

                            map.setCenter(new google.maps.LatLng(lat, lng));
                            map.setZoom(14);
                            marker = new google.maps.Marker({
                                draggable: true,
                                position: latlng,
                                map: map
                            });
                            google.maps.event.addListener(marker, 'dragend', function (event) {
                                lat = this.getPosition().lat();
                                lng = this.getPosition().lng();
                                latlng = {lat: lat, lng: lng};

                                geocoder.geocode({'location': latlng}, function (results, status) {
                                    if (status === 'OK') {

                                        // console.log('drag in address complete');
                                        // console.log(results);

                                        saveLocation(results, lat, lng);

                                        if (results[1]) {
                                            $("#map_address").val(results[1].formatted_address);
                                        }
                                    }
                                });
                            });
                        }
                    });
                }
            });

            google.maps.event.addListener(marker, 'dragend', function (event) {
                lat = this.getPosition().lat();
                lng = this.getPosition().lng();
                latlng = {lat: this.getPosition().lat(), lng: this.getPosition().lng()};
                geocoder.geocode({'location': latlng}, function (results, status) {
                    if (status === 'OK') {

                        // console.log('drag');
                        // console.log(results);

                        saveLocation(results, lat, lng);

                        if (results[1]) {
                            $("#map_address").val(results[1].formatted_address);
                        }
                    }
//                map.setZoom(14);
                });
            });

            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function (positions) {
                    lat = positions.coords.latitude;
                    lng = positions.coords.longitude;

                    if(marker){
                        marker.setMap(null);
                    }
                    var latlng = {lat: lat, lng: lng};
                    geocoder.geocode({'location': latlng}, function (results, status) {
                        if (status === 'OK') {

                            // console.log('geocoder');
                            // console.log(results);

                            saveLocation(results, lat, lng);


                            if (results[1]) {
                                $("#map_address").val(results[1].formatted_address);
                                map.setCenter(new google.maps.LatLng(lat, lng));
                                marker = new google.maps.Marker({
                                    draggable: true,
                                    position: latlng,
                                    map: map
                                });
                                map.setZoom(14);
                                google.maps.event.addListener(marker, 'dragend', function (event) {
                                    lat = this.getPosition().lat();
                                    lng = this.getPosition().lng();
                                    latlng = {lat: this.getPosition().lat(), lng: this.getPosition().lng()};

                                    geocoder.geocode({'location': latlng}, function (results, status) {
                                        if (status === 'OK') {

                                            // console.log('dragend in geocoder');
                                            // console.log(results);

                                            saveLocation(results, lat, lng);


                                            if (results[1]) {
                                                $("#map_address").val(results[1].formatted_address);
                                            }
                                        }
                                    });
                                });
                            }
                        }
                    });
                });
            }

        }, 30);

    });

});
