<?php
return [
    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | such as the size rules. Feel free to tweak each of these messages.
    |
    */
    'accepted'             => 'يجب قبول :attribute',
    'active_url'           => ':attribute لا يُمثّل رابطًا صحيحًا',
    'after'                => 'يجب على :attribute أن يكون تاريخًا لاحقًا للتاريخ :date.',
    'after_or_equal'       => ':attribute يجب أن يكون تاريخاً لاحقاً أو مطابقاً للتاريخ :date.',
    'alpha'                => 'يجب أن لا يحتوي :attribute سوى على حروف',
    'alpha_dash'           => 'يجب أن لا يحتوي :attribute على حروف، أرقام ومطّات.',
    'alpha_num'            => 'يجب أن يحتوي :attribute على حروفٍ وأرقامٍ فقط',
    'array'                => 'يجب أن يكون :attribute ًمصفوفة',
    'before'               => 'يجب على :attribute أن يكون تاريخًا سابقًا للتاريخ :date.',
    'before_or_equal'      => ':attribute يجب أن يكون تاريخا سابقا أو مطابقا للتاريخ :date',
    'between'              => [
        'numeric' => 'يجب أن تكون قيمة :attribute بين :min و :max.',
        'file'    => 'يجب أن يكون حجم الملف :attribute بين :min و :max كيلوبايت.',
        'string'  => 'يجب أن يكون عدد حروف النّص :attribute بين :min و :max',
        'array'   => 'يجب أن يحتوي :attribute على عدد من العناصر بين :min و :max',
    ],
    'boolean'              => 'يجب أن تكون قيمة :attribute إما true أو false ',
    'confirmed'            => 'حقل التأكيد غير مُطابق للحقل :attribute',
    'date'                 => ':attribute ليس تاريخًا صحيحًا',
    'date_format'          => 'لا يتوافق :attribute مع الشكل :format.',
    'different'            => 'يجب أن يكون الحقلان :attribute و :other مُختلفان',
    'digits'               => 'يجب أن يحتوي :attribute على :digits رقمًا/أرقام',
    'digits_between'       => 'يجب أن يحتوي :attribute بين :min و :max رقمًا/أرقام ',
    'dimensions'           => 'الـ :attribute يحتوي على أبعاد صورة غير صالحة.',
    'distinct'             => 'للحقل :attribute قيمة مُكرّرة.',
    'email'                => 'يجب أن يكون :attribute عنوان بريد إلكتروني صحيح البُنية',
    'exists'               => ':attribute غير موجود',
    'file'                 => 'الـ :attribute يجب أن يكون ملفا.',
    'filled'               => ':attribute إجباري',
    'image'                => 'يجب أن يكون :attribute صورةً',
    'in'                   => ':attribute غير موجود',
    'in_array'             => ':attribute غير موجود في :other.',
    'integer'              => 'يجب أن يكون :attribute عددًا صحيحًا',
    'ip'                   => 'يجب أن يكون :attribute عنوان IP صحيحًا',
    'ipv4'                 => 'يجب أن يكون :attribute عنوان IPv4 صحيحًا.',
    'ipv6'                 => 'يجب أن يكون :attribute عنوان IPv6 صحيحًا.',
    'json'                 => 'يجب أن يكون :attribute نصآ من نوع JSON.',
    'max'                  => [
        'numeric' => 'يجب أن تكون قيمة :attribute مساوية أو أصغر لـ :max.',
        'file'    => 'يجب أن لا يتجاوز حجم الملف :attribute :max كيلوبايت',
        'string'  => 'يجب أن لا يتجاوز طول النّص :attribute :max حروفٍ/حرفًا',
        'array'   => 'يجب أن لا يحتوي :attribute على أكثر من :max عناصر/عنصر.',
    ],
    'mimes'                => 'يجب أن يكون ملفًا من نوع : :values.',
    'mimetypes'            => 'يجب أن يكون ملفًا من نوع : :values.',
    'min'                  => [
        'numeric' => 'يجب أن تكون قيمة :attribute مساوية أو أكبر لـ :min.',
        'file'    => 'يجب أن يكون حجم الملف :attribute على الأقل :min كيلوبايت',
        'string'  => 'يجب أن يكون طول النص :attribute على الأقل :min حروفٍ/حرفًا',
        'array'   => 'يجب أن يحتوي :attribute على الأقل على :min عُنصرًا/عناصر',
    ],
    'not_in'               => ':attribute غير موجود',
    'numeric'              => 'يجب على :attribute أن يكون رقمًا',
    'present'              => 'يجب تقديم :attribute',
    'regex'                => 'صيغة :attribute .غير صحيحة',
    'required'             => ':attribute مطلوب.',
    'required_if'          => ':attribute مطلوب إذا كان :other يساوي :value.',
    'required_unless'      => ':attribute مطلوب في حال ما لم يكن :other يساوي :values.',
    'required_with'        => ':attribute مطلوب إذا توفّر :values.',
    'required_with_all'    => ':attribute مطلوب إذا توفّر :values.',
    'required_without'     => ':attribute مطلوب إذا لم يتوفّر :values.',
    'required_without_all' => ':attribute مطلوب إذا لم يتوفّر :values.',
    'same'                 => 'يجب أن يتطابق :attribute مع :other',
    'size'                 => [
        'numeric' => 'يجب أن تكون قيمة :attribute مساوية لـ :size',
        'file'    => 'يجب أن يكون حجم الملف :attribute :size كيلوبايت',
        'string'  => 'يجب أن يحتوي النص :attribute على :size حروفٍ/حرفًا بالظبط',
        'array'   => 'يجب أن يحتوي :attribute على :size عنصرٍ/عناصر بالظبط',
    ],
    'string'               => 'يجب أن يكون :attribute نصآ.',
    'timezone'             => 'يجب أن يكون :attribute نطاقًا زمنيًا صحيحًا',
    'unique'               => 'قيمة :attribute مُستخدمة من قبل',
    'uploaded'             => 'فشل في تحميل الـ :attribute',
    'url'                  => 'صيغة الرابط :attribute غير صحيحة',
    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */
    'custom'               => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],
    'values' => [
        'service_place' => [
            'home' => 'المنزل',
            'center' => 'المركز',
        ],
        'category_id' => [
            '3' => 'تصميم',
        ],
        'payment_type' => [
            'bank_transfer' => 'تحويل بنكي',
        ],

    ],
    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */
    'attributes'           => [
        'name'                  => 'الاسم',
        'phone'                  => 'رقم الجوال',
        'email'                  => 'البريد الالكتروني',
        'description'                  => 'نبذة عني',
        'username'                 => 'اسم المستخدم',
        'country_id'              => 'الدولة',
        'city_id'            => 'المدينة',
        'user_type'            => 'نوع الحساب',// 1 for user 2 for Service Provider
        'gender'            => 'الجنس',// 1 for female 2 for male
        'image'            => 'الصورة',
        'photo'            => 'الصورة',
        'identity_image'            => 'صورة الهوية',
        'account_number'            => 'رقم الحساب',
        'facebook_account'            => 'حساب الفيس بوك',
        'twitter_account'            => 'حساب تويتر',
        'instagram_account'            => 'حساب انستجرام',
        'sections'            => 'الاقسام',

        'device_token'          => 'device token',
        'device_identifier'           => 'device identifier',
        'language'           => 'اللغة',
        'link'           => 'الرابط',
        'code'           => 'رمز التأكيد',
        'active'           => 'التفعيل',
        'comment'           => 'التعليق',
        'title'           => 'العنوان',
        'city'           => 'المدينة',
        'details'           => 'تفاصيل الطلب',
        'categories'           => 'القسم',
        'order_date'           => 'تاريخ الطلب',
        'cost'           => 'المبلغ المطلوب لتنفيذ الخدمة',
        'text'           => 'المحتوى',
        'order_id'           => 'رقم الطلب',
        'price'           => 'السعر',
        'note'           => 'الملاحظات',
        'transaction_id'           => 'رقم عملية الدفع',
        'online'           => 'متاح',
        'amount'           => 'المبلغ',
        'bank_name'           => 'اسم البنك',
        'password'           => 'كلمة المرور',
        'terms'           => 'الشروط والأحكام',
        'terms.*'           => 'الشروط والأحكام بلغة',
        'about'           => 'من نحن',
        'about.*'           => 'من نحن بلغة',
        'minimum_pull_wallet'           => 'حد ادنى للسحب من المحفظة',
        'product_percentage'           => 'النسبة المئوية للادارة في المنتجات',
        'service_percentage'           => 'النسبة المئوية للادارة في الخدمات',
        'cancel_period_status'           => 'حالة اتاحة الغاء الطلب',
        'cancel_period_time'           => 'الوقت المتاح لالغاء الطلب',
        'name.*'                    => 'اسم بلغة',
        'home_display'                    => 'عرض في الصفحة الرئيسية',
        'calling_code'                    => 'كود الدولة',
        'country_code'                    => 'كود الدولة',
        'training_level_id'                    => 'مستوى التدريب',
        'password_confirmation'                    => 'تأكيد كلمة المرور',
        'reset_code'                    => 'كود الاسترجاع',
        'old_password'                    => 'كلمة المرور القديمة',
        'get_application_id'                    => 'كيف وصلت للتطبيق',
        'provider_code'                    => 'كود مزود الخدمة',
        'account_type_id'                    => 'نوع الحساب',
        'year_experience_number'                    => 'عدد سنوات الخبرة',
        'trade_name'                    => 'الاسم التجاري',
        'work_available'                    => 'متاح للطلب ضمن مواعيد عمل محددة',
        'schedule_work_time'                    => 'جدول الاعمال',
        'cover'                    => 'غلاف الملف الشخصي',
        'trade_videos'                    => 'فيديو الاعمال',
        'trade_images'                    => 'صور الاعمال',
        'time_scale_id'                    => 'مقياس الوقت',
        'images'                    => 'الصور',
        'videos'                    => 'الفيديو',
        'category_id'                    => 'القسم',
        'lat'                    => 'الخريطه',
        'lng'                    => 'الخريطه',
        'number_of_people'                    => 'عدد الاشخاص',
        'date_time'                    => 'التاريخ والوقت',
        'address'                    => 'عنوان المركز',
        'time'                    => 'مدة الخدمة',
        'cancel_reason'                    => 'سبب الالغاء',
        'message'                    => 'رسالتك',
        'region_id'                    => 'المنطقة',
        'street_name'                    => 'اسم الشارع',
        'building_number'                    => 'رقم /اسم البناية',
        'trade_mark'                    => 'علامة تجارية',
        'default_address'                    => 'العنوان الرئيسي',
        'count'                    => 'الكمية',
        'product_type_id'                    => 'المنتج',
        'coupon'                    => 'قسيمة الخصم',
        'address_id'                    => 'العنوان',
        'payment_method'                    => 'طريقة الدفع',
        'rate'                    => 'التقييم',
        'message.*'                    => 'الرسالة بلغة',
        'title.*'                    => 'عنوان الرسالة بلغة',
        'categories.*'                    => 'الاقسام',
        'commercial_image'                    => 'صورة السجل التجاري',
        'experience_certificate_image'                    => 'صورة شهادة الخبرة',
        'show_experience_certificate'                    => 'اظهار  شهادة الخبرة',
        'user_id'                    => 'رقم العضو',
        'service_place'                    => 'مكان الخدمة',
        'service_id'                    => 'الخدمة',
        'material'                    => 'الخامة',
        'color'                    => 'اللون',
        'size'                    => 'المقاس',
        'brand_name'                    => 'الماركة',
        'edits'                    => 'التعديلات',
        'defects'                    => 'العيوب',
        'model_year'                    => 'الموديل',
        'type'                    => 'نوع',
        'images.*'                    => 'الصور',
        'subject'                    => 'عنوان الرسالة',
        'employee_name'=>'اسم الموظف',
        'employee_id'=> 'رقم الموظف',
        'user_phone'=>'رقم الجوال',
        'complaint_subject'=>'موضوع الشكوى',
        'complaint_statement' => 'بيان الشكوى',
        'cv_image' => 'صورة الهوية',
        'date' => 'تاريخ تقديم الطلب',
        'notes' => 'الملاحظات',
        'payment_type' => 'طريقة الدفع',
        'bank_id' => 'البنك',
        'user_name' => 'اسم المحول',
        'transfer_image' => 'صورة التحويل',
        'current_password' => 'كلمة المرور الحالية',
        'new_password' => 'كلمة المرور الجديدة',
        'password_confirm' => 'تأكيد كلمة المرور ',
        'balance' => 'المبلغ المراد سحبه ',
        'sub_service_id' => 'الخدمات الفرعية',
        'cv_photo' => 'ملف السيرة الذاتية',
        'order' => 'نوع الطلب',
        'product_id' => 'رقم المنتج',
        'photos.*' => 'الصور ',
        'iban' => 'الايبان ',



    ],
];
