@extends('admin.layouts.master')

@section('title')
    @lang('messages.my_profile')
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />

@endsection

@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item active">@lang('messages.my_profile')</li>
                    </ol>
                </div>
                <h4 class="page-title">@lang('messages.my_profile')</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection


@section('content')


    <div class="row">
        <div class="col-9">
            <div class="card">
                <div class="card-body">
                    {!! Form::open(['url' => route('admin.update-profile'),'class' => 'form-horizontal']) !!}

                    <div class="form-body">
                        <div class="form-group">
                            <label for="name" class="col-lg-3 control-label">@lang('messages.name')
                                <span class="text-danger">*</span>
                            </label>
                            <div class="col-lg-9">
                                <input id="name" name="name" value="{{ isset($admin) ? $admin->name : old('name') }}" type="text" class="form-control" placeholder="{{trans('messages.name')}}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="email" class="col-lg-3 control-label">@lang('messages.email')
                                <span class="text-danger">*</span>
                            </label>
                            <div class="col-lg-9">
                                <input id="email" name="email" value="{{ isset($admin) ? $admin->email : old('email') }}" type="email" class="form-control phone-text" placeholder="{{trans('messages.email')}}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="phone" class="col-lg-3 control-label">@lang('messages.phone')
                                <span class="text-danger">*</span>
                            </label>
                            <div class="col-lg-9">
                                <input id="phone" name="phone" value="{{ isset($admin) ? $admin->phone : old('phone') }}" type="text" class="form-control phone-text" placeholder="{{trans('messages.phone')}}">
                            </div>
                        </div>

                    </div>
                    <div class="form-group mb-0 justify-content-end row">
                        <button type="submit" class="btn btn-info waves-effect waves-light"> @lang('messages.save')</button>
                    </div>

                    {!! Form::close() !!}

                </div>  <!-- end card-body -->
            </div>  <!-- end card -->
        </div>  <!-- end col -->
    </div>
    <!-- end row-->
@endsection


