@extends('admin.layouts.master')

@section('title')
    تعديل المدن
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/bootstrap-colorpicker/bootstrap-colorpicker.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/clockpicker/bootstrap-clockpicker.min.css') }}" rel="stylesheet" type="text/css" />
@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.cities.index') }}">المدن</a></li>
                        <li class="breadcrumb-item active">تعديل المدن</li>
                    </ol>
                </div>
                <h4 class="page-title">تعديل المدن</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-9">
            {!! Form::model($city, ['method' => 'PATCH', 'url' => route('admin.cities.update', $city->id),'class' => 'form-horizontal form-row-seperated', 'files'=> 'true']) !!}
            <div class="card-box">
                <h4 class="header-title mb-4">@lang('messages.information') المدن</h4>
                <div class="actions btn-set btn-position" >
                    <button class="btn btn-success" type="submit" >
                        @lang('messages.save')
                    </button>
                </div>

                <div class="card-box">
                        @include('admin.cities._form')
                </div>
            </div> <!-- end card-box-->
            {!! Form::close() !!}
        </div> <!-- end col -->


    </div>
    <!-- end row -->


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/moment/moment.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-colorpicker/bootstrap-colorpicker.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/clockpicker/bootstrap-clockpicker.min.js') }}"></script>
    <!-- Init js-->
    <script src="{{ URL::asset('admin/js/pages/form-pickers.init.js') }}"></script>
@endsection
