@extends('admin.layouts.master')

@section('title')
    تعديل الدول
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/bootstrap-colorpicker/bootstrap-colorpicker.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/clockpicker/bootstrap-clockpicker.min.css') }}" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="{{ URL::asset('admin/css/bootstrap-fileinput.css') }}">
@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.countries.index') }}">الدول</a></li>
                        <li class="breadcrumb-item active">تعديل الدول</li>
                    </ol>
                </div>
                <h4 class="page-title">تعديل الدول</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-9">
            {!! Form::model($country, ['method' => 'PATCH', 'url' => route('admin.countries.update', $country->id),'class' => 'form-horizontal form-row-seperated', 'files'=> 'true']) !!}
            <div class="card-box">
                <h4 class="header-title mb-4">@lang('messages.information') الدول</h4>
                <div class="actions btn-set btn-position" >
                    <button class="btn btn-success" type="submit" >
                        @lang('messages.save')
                    </button>
                </div>


                <ul class="nav nav-tabs nav-bordered">
                    <li class="nav-item">
                        <a href="#general" data-toggle="tab" aria-expanded="false" class="nav-link active">
                            @lang('messages.general')
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#another" data-toggle="tab" aria-expanded="true" class="nav-link">
                            @lang('messages.another')
                        </a>
                    </li>
                </ul>
                <div class="card-box">
                    <div class="tab-content">
                        @include('admin.countries._form')


                    </div>
                </div>
            </div> <!-- end card-box-->
            {!! Form::close() !!}
        </div> <!-- end col -->


    </div>
    <!-- end row -->


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/js/bootstrap-fileinput.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/moment/moment.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-colorpicker/bootstrap-colorpicker.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/clockpicker/bootstrap-clockpicker.min.js') }}"></script>
    <!-- Init js-->
    <script src="{{ URL::asset('admin/js/pages/form-pickers.init.js') }}"></script>
@endsection
