@extends('admin.layouts.master')

@section('title')
    @lang('messages.Dashboards')
@endsection

@section('content')


        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title">ملخص المبيعات والطلبات </h4>
                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <div class="col-xl-3 col-md-6">
                <div class="card-box">


                    <h4 class="header-title mt-0 mb-2">إجمالي عدد المبيعات</h4>

                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#f05050 "
                                   data-bgColor="#F9B9B9" value="{{$allProducts ? round($allOrdersSales/$allProducts*100) : 0}}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1"> {{$allOrdersSales}} </h2>
                            <p class="text-muted mb-0">منتج</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->

            <div class="col-xl-3 col-md-6">
                <div class="card-box">

                    <h4 class="header-title mt-0 mb-3">إجمالي المبيعات الشهرية</h4>
                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#675db7"
                                   data-bgColor="#e8e7f4" value="{{$allProducts ? round($ordersDoneMonth/$allProducts*100) : 0}}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1"> {{$ordersDoneMonth}} </h2>
                            <p class="text-muted mb-0">منتج</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->

            <div class="col-xl-3 col-md-6">
                <div class="card-box">


                    <h4 class="header-title mt-0 mb-3">إجمالي مبيعات الإسبوع</h4>

                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#23b397"
                                   data-bgColor="#c8ece5" value="{{$allProducts ? round($ordersDoneWeek/$allProducts*100) : 0}}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1"> {{$ordersDoneWeek}} </h2>
                            <p class="text-muted mb-0">منتج</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->


            <div class="col-xl-3 col-md-6">
                <div class="card-box">
                    <h4 class="header-title mt-0 mb-3">إجمالي مبيعات اليوم</h4>

                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#ffbd4a"
                                   data-bgColor="#FFE6BA" value="{{$allProducts ? round($ordersDoneDay/$allProducts*100) : 0}}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1">{{$ordersDoneDay}} </h2>
                            <p class="text-muted mb-0">منتج</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->
            <div class="col-xl-3 col-md-6">
                <div class="card-box">


                    <h4 class="header-title mt-0 mb-2">إجمالي قيمة المبيعات</h4>

                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#f05050 "
                                   data-bgColor="#F9B9B9" value="{{$allProducts ? 100 : 0}}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1"> {{round($allOrdersSalesTotal,2)}} </h2>
                            <p class="text-muted mb-0">ريال سعودي</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->

            <div class="col-xl-3 col-md-6">
                <div class="card-box">

                    <h4 class="header-title mt-0 mb-3">إجمالي قيمة المبيعات الشهرية</h4>
                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#675db7"
                                   data-bgColor="#e8e7f4" value="{{$allOrdersSalesTotal ? round($ordersDoneMonthTotal/$allOrdersSalesTotal*100) : 0}}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1"> {{round($ordersDoneMonthTotal,2)}} </h2>
                            <p class="text-muted mb-0">ريال سعودي</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->

            <div class="col-xl-3 col-md-6">
                <div class="card-box">


                    <h4 class="header-title mt-0 mb-3">إجمالي قيمة مبيعات الإسبوع</h4>

                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#23b397"
                                   data-bgColor="#c8ece5" value="{{$allOrdersSalesTotal ? round($ordersDoneWeekTotal/$allOrdersSalesTotal*100) : 0}}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1"> {{round($ordersDoneWeekTotal,2)}} </h2>
                            <p class="text-muted mb-0">ريال سعودي</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->


            <div class="col-xl-3 col-md-6">
                <div class="card-box">
                    <h4 class="header-title mt-0 mb-3">إجمالي قيمة مبيعات اليوم</h4>

                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#ffbd4a"
                                   data-bgColor="#FFE6BA" value="{{$allOrdersSalesTotal ? round($ordersDoneDayTotal/$allOrdersSalesTotal*100) : 0}}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1">{{round($ordersDoneDayTotal,2)}} </h2>
                            <p class="text-muted mb-0">ريال سعودي</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->


            <div class="col-xl-3 col-md-6">
                <div class="card-box">
                    <h4 class="header-title mt-0 mb-3">طلبات قيد المراجعة</h4>

                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#ffbd4a"
                                   data-bgColor="#FFE6BA" value="{{$allOrders ? round($ordersNew/$allOrders*100) : 0}}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1">{{$ordersNew}} </h2>
                            <p class="text-muted mb-0">طلب</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->


            <div class="col-xl-3 col-md-6">
                <div class="card-box">


                    <h4 class="header-title mt-0 mb-2">طلبات جاري التجهيز</h4>

                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#f05050 "
                                   data-bgColor="#F9B9B9" value="{{$allOrders ? round($ordersIn_progress/$allOrders*100) : 0}}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1"> {{$ordersIn_progress}} </h2>
                            <p class="text-muted mb-0">طلب</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->

            <div class="col-xl-3 col-md-6">
                <div class="card-box">

                    <h4 class="header-title mt-0 mb-3">طلبات تم توصيلها</h4>
                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#675db7"
                                   data-bgColor="#e8e7f4" value="{{$allOrders ? round($ordersDone/$allOrders*100) : 0}}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1"> {{$ordersDone}} </h2>
                            <p class="text-muted mb-0">طلب</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->


        </div>
        <!-- end row -->
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title">ملخص الأقسام والمنتجات</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <div class="col-xl-3 col-md-6">
                <div class="card-box">


                    <h4 class="header-title mt-0 mb-2">مجموع الأقسام الرئيسية</h4>

                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#23b397"
                                   data-bgColor="#c8ece5" value="100"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>

                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1"> {{$categories}} </h2>
                            <p class="text-muted mb-0">قسم</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->

            <div class="col-xl-3 col-md-6">
                <div class="card-box">

                    <h4 class="header-title mt-0 mb-3">مجموع الأقسام الفرعية</h4>
                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#f05050 "
                                   data-bgColor="#F9B9B9" value="100"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1"> {{$SubCategories}} </h2>
                            <p class="text-muted mb-0">قسم</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->

            <div class="col-xl-3 col-md-6">
                <div class="card-box">


                    <h4 class="header-title mt-0 mb-3">إجمالي عدد المنتجات</h4>

                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#675db7"
                                   data-bgColor="#e8e7f4" value="100"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1"> {{$allProducts}} </h2>
                            <p class="text-muted mb-0">منتج</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->


            <div class="col-xl-3 col-md-6">
                <div class="card-box">
                    <h4 class="header-title mt-0 mb-3">المنتجات ذات العروض</h4>

                    <div class="mt-1">
                        <div class="float-left" dir="ltr">
                            <input data-plugin="knob" data-width="64" data-height="64" data-fgColor="#ffbd4a"
                                   data-bgColor="#FFE6BA" value="{{$allProducts ? round($offerProduct/$allProducts*100) : 0 }}"
                                   data-skin="tron" data-angleOffset="180" data-readOnly=true
                                   data-thickness=".15"/>
                        </div>
                        <div class="text-right">
                            <h2 class="mt-3 pt-1 mb-1">{{$offerProduct}} </h2>
                            <p class="text-muted mb-0">منتج</p>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div><!-- end col -->
        </div>
        <!-- end row -->




@endsection



