<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="{{ app()->getLocale() }}">
<!--<![endif]-->
<!-- BEGIN HEAD -->
<head>
    <meta charset="utf-8" />
    <meta name="X-CSRF-TOKEN" content="{{ csrf_token() }}">
    <title>لوحة التحكم | @yield('title')</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="og:title" content="{{trans('web.meta_title')}}" />
    <meta content="{{trans('web.meta_description')}}" name="description" />
    <meta content="Coderthemes" name="author" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <link href="https://fonts.googleapis.com/css?family=Cairo&display=swap" rel="stylesheet">
    <!-- App favicon -->
    <link rel="shortcut icon" href="{{ URL::asset('admin/images/logo_user.jpg') }}">

    @yield('styles')
    <!-- plugin css -->
    <link href="{{ URL::asset('admin/libs/jquery-vectormap/jquery-jvectormap-1.2.2.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <!-- App css -->
    <link href="{{ URL::asset('admin/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/css/app-rtl.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/css/custom.css') }}" rel="stylesheet" type="text/css" />




</head>

<!-- END HEAD -->

<body>

<!-- Begin page -->
<div id="wrapper">
@include('admin.layouts.header')

@include('admin.layouts.sidebar')

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                    @yield('page_header')

                    @include('admin.layouts.alerts')

                    @yield('content')

            </div> <!-- container -->

        </div> <!-- content -->


    </div>


</div>
<!-- END wrapper -->

{{--@include('admin.layouts.right_sidebar')--}}

<!-- Right bar overlay-->
<div class="rightbar-overlay"></div>

<!-- Vendor js -->
<script src="{{ URL::asset('admin/js/vendor.min.js') }}"></script>

<!-- Third Party js-->
<script src="{{ URL::asset('admin/libs/peity/jquery.peity.min.js') }}"></script>
<script src="{{ URL::asset('admin/libs/jquery-knob/jquery.knob.min.js') }}"></script>
<script src="{{ URL::asset('admin/libs/peity/jquery.peity.min.js') }}"></script>



<!-- App js -->
<script src="{{ URL::asset('admin/js/app.min.js') }}"></script>
@yield('scripts')

</body>
</html>
