@extends('admin.layouts.master')

@section('title')
    تغيير حالة الطلب
@endsection
@section('styles')
    <link href="{{ URL::asset('admin/libs/jquery-nice-select/nice-select.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />

@endsection
@section('page_header')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">الاعضاء</a></li>
                        <li class="breadcrumb-item active"> تغيير حالة الطلب</li>
                    </ol>
                </div>
                <h4 class="page-title">  تغيير حالة الطلب <span> <a href="{{ route('admin.users.show', $user->id) }}"> {{ $user->name }} </a> </span>
                </h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col-9">
            <div class="card">
                <div class="card-body">


                    {!! Form::open([ 'url' => route('admin.orders.change-accept-status-update-order', $order->id), 'class' => 'form-horizontal' ]) !!}

                    <div class="form-group ">
                        <label for="status" class="col-md-3 col-form-label">قبول الطلب لاستكمال عملية الدفع :
                            <span class="text-danger">*</span>
                        </label>

                        <div class="col-9">
                            <select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="accept_status" name="accept_status" parsley-trigger="change" required >
                                <option value>اختر حالة الطلب</option>

                                <option value="1" {{$order->accept_status == "1" ? 'selected' : ''}}>موافقة على استكمال الدفع</option>
                                <option value="0" {{$order->accept_status == "0" ? 'selected' : ''}}>رفض استكمال عملية الدفع</option>

                            </select>
                        </div>
                    </div>

                    <div class="form-group mb-0 justify-content-end row">
                        <button type="submit" class="btn btn-info waves-effect waves-light"  onclick="this.disabled=true;this.value='تم الارسال, انتظر...';this.form.submit();">  تعديل</button>
                    </div>


                    {!! Form::close() !!}

                </div>  <!-- end card-body -->
            </div>  <!-- end card -->
        </div>  <!-- end col -->
    </div>
    <!-- end row-->

@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.js') }}"></script>
@endsection
