
    <div class="form-group row mb-3">
        <label class="col-md-3 col-form-label">@lang('messages.image'):
            <span class="text-danger">*</span>
            <p class="text-danger">المقاس المفضل (578*1600)</p>
        </label>
        <div class="col-9">
            <div class="fileinput fileinput-new" data-provides="fileinput">
                <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 330px; height: 150px;">
                    @if( isset($slider->image) )
                        <img src="{{ URL::asset('uploads/sliders/'.$slider->image) }}">
                    @endif
                </div>
                <div>
                        <span  class="btn btn-outline-danger waves-effect waves-light btn-file">
                            <span class="fileinput-new"> @lang('messages.change') @lang('messages.image') </span>
                            <span class="fileinput-exists"> @lang('messages.change') </span>
                            <input type="file" name="photo" accept="image/*" {{isset($slider->image) ? '' : ' parsley-trigger="change" required' }}>
                        </span>
                    <a href="javascript:;" class="btn btn-outline-danger waves-effect waves-light fileinput-exists" data-dismiss="fileinput"> @lang('messages.delete') </a>
                </div>
            </div>
        </div>
    </div>
    <div class="form-group row mb-3">
        <label class="col-md-3 col-form-label">@lang('messages.image') (EN):
            <span class="text-danger">*</span>
            <p class="text-danger">المقاس المفضل (578*1600)</p>
        </label>
        <div class="col-9">
            <div class="fileinput fileinput-new" data-provides="fileinput">
                <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 330px; height: 150px;">
                    @if( isset($slider->image_en) )
                        <img src="{{ URL::asset('uploads/sliders/'.$slider->image_en) }}">
                    @endif
                </div>
                <div>
                        <span  class="btn btn-outline-danger waves-effect waves-light btn-file">
                            <span class="fileinput-new"> @lang('messages.change') @lang('messages.image') </span>
                            <span class="fileinput-exists"> @lang('messages.change') </span>
                            <input type="file" name="photo_en" accept="image/*" {{isset($slider->image_en) ? '' : ' parsley-trigger="change" required' }}>
                        </span>
                    <a href="javascript:;" class="btn btn-outline-danger waves-effect waves-light fileinput-exists" data-dismiss="fileinput"> @lang('messages.delete') </a>
                </div>
            </div>
        </div>
    </div>
    <div class="form-group row mb-3">
        <label for="link_type" class="col-md-3 col-form-label">نوع الرابط
            <span class="text-danger">*</span>
        </label>

        <div class="col-9">
            <select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="link_type" name="link_type" parsley-trigger="change" required >
                <option value>نوع الرابط</option>
                <option value="category" {{ isset($slider) ? $slider->link_type == "category" ? "selected" : '' : old("link_type") == "category"  ? "selected" : ""  }}>قسم</option>
                <option value="product" {{ isset($slider) ? $slider->link_type == "product" ? "selected" : '' : old("link_type") == "product" ? "selected" : ""  }}>منتج</option>
                <option value="external_link" {{ isset($slider) ? $slider->link_type == "external_link" ? "selected" : '' : old("link_type") == "external_link" ? "selected" : ""  }}>رابط خارجي</option>
                <option value="just_ads" {{ isset($slider) ? $slider->link_type == "just_ads" ? "selected" : '' : old("link_type") == "just_ads" ? "selected" : ""  }}>اعلان مجرد</option>

            </select>
        </div>
    </div>
    <div id="category" >
        @if(isset($slider) && $slider->link_type =="category")
            <div class="form-group row mb-3">
            <label for="category_id" class="col-md-3 col-form-label">القسم الرئيسي
                <span class="text-danger">*</span>
            </label>

            <div class="col-9">
                <select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="category_id" name="category_id" parsley-trigger="change" required >
                    <option value>القسم الرئيسي</option>
                    @foreach($categories as $data)

                        <option value="{{$data->id}}" {{ isset($slider) ? $data->id == ( $parent_id == null  ? $slider->category_id : $parent_id)  ? "selected" : '' : old("category_id") == $data->id  ? "selected" : ""  }}>{{$data->name['ar']}}</option>

                    @endforeach

                </select>
            </div>
            </div>

        @endif
    </div>
    <div id="sub_category" >
        @if(isset($slider) && $slider->link_type =="category" && $parent_id !== null)
            <div class="form-group row mb-3">
                <label for="sub_category_id" class="col-md-3 col-form-label">القسم الفرعي
                    <span class="text-danger">*</span>
                </label>

                <div class="col-9">
                    <select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="sub_category_id" name="sub_category_id" parsley-trigger="change" required >
                        <option value>القسم  الفرعي</option>
                        @foreach(\App\Models\Category::whereParentId($parent_id)->get() as $data)

                            <option value="{{$data->id}}" {{ isset($slider) ? $data->id == $slider->category_id  ? "selected" : '' : old("sub_category_id") == $data->id  ? "selected" : ""  }}>{{$data->name['ar']}}</option>

                        @endforeach

                    </select>
                </div>
            </div>

        @endif
    </div>
    <div id="product">
        @if(isset($slider) && $slider->link_type =="product")
            <div class="form-group row mb-3">
                <label for="product_id" class="col-md-3 col-form-label">المنتجات
                    <span class="text-danger">*</span>
                </label>

                <div class="col-9">
                    <select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="product_id" name="product_id" parsley-trigger="change" required >
                        <option value>المنتجات</option>
                        @foreach($products as $data)

                            <option value="{{$data->id}}" {{ isset($slider) ? $data->id == $slider->product_id  ? "selected" : '' : old("product_id") == $data->id  ? "selected" : ""  }}>{{$data->title['ar']}}</option>

                        @endforeach

                    </select>
                </div>
            </div>

        @endif
    </div>
    <div id="link">
        @if(isset($slider) && $slider->link_type == "external_link")
            <div class="form-group row mb-3">
                <label for="link" class="col-md-3 col-form-label">
                    رابط خارجي<span class="text-danger">*</span>
                </label>
                 <div class="col-9">
                     <input type="text"  name="link" class="form-control" placeholder="رابط خارجي" value="{{$slider->link}}" parsley-trigger="change" required >
                 </div>
            </div>
        @endif
    </div>
