@extends('admin.layouts.master')

@section('title')
    @lang('messages.change_Password')
@endsection

@section('page_header')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">الاعضاء</a></li>
                        <li class="breadcrumb-item active"> @lang('messages.change_Password')</li>
                    </ol>
                </div>
                <h4 class="page-title">  تغيير كلمة المرور <span> <a href="{{ route('admin.users.show', $user->id) }}"> {{ $user->name }} </a> </span>
                </h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col-9">
            <div class="card">
                <div class="card-body">


                    {!! Form::open([ 'url' => route('admin.users.post.change-password', $user), 'class' => 'form-horizontal' ]) !!}

                    <div class="form-group">
                        <label for="new_password" class="col-lg-3 control-label">@lang('messages.new_password')</label>
                        <div class="col-lg-9">
                            <input id="new_password" name="new_password" type="password" class="form-control" placeholder="{{trans('messages.new_password')}}">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password_confirm" class="col-lg-3 control-label">@lang('messages.Repeat_the_password')</label>
                        <div class="col-lg-9">
                            <input id="password_confirm" name="password_confirm" type="password" class="form-control" placeholder="{{trans('messages.Repeat_the_password')}}">
                        </div>
                    </div>

                    <div class="form-group mb-0 justify-content-end row">
                        <button type="submit" class="btn btn-info waves-effect waves-light"  onclick="this.disabled=true;this.value='تم الارسال, انتظر...';this.form.submit();">  @lang('messages.save') </button>
                    </div>


                    {!! Form::close() !!}

                </div>  <!-- end card-body -->
            </div>  <!-- end card -->
        </div>  <!-- end col -->
    </div>
    <!-- end row-->

@endsection
