<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\Auth\LoginController;
use App\Http\Controllers\Admin\HomeController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\CityController;
use App\Http\Controllers\Admin\PaymentMethodController;
use App\Http\Controllers\Admin\RegionController;
use App\Http\Controllers\Admin\SubCategoryController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\CouponsController;
use App\Http\Controllers\Admin\BankController;
use App\Http\Controllers\Admin\PostController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\CommentController;
use App\Http\Controllers\Admin\DealerController;
use App\Http\Controllers\Admin\BankTransferController;
use App\Http\Controllers\Admin\PullController;
use App\Http\Controllers\Admin\QuestionController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\NotificationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

//Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');


/* payment for mobile*/
Route::get( '/redirect_url', [\App\Http\Controllers\Api\User\PaymentController::class,"payment_type"]);
/* start admin control*/
Route::get( '/', [\App\Http\Controllers\HomeController::class,"index"]);
Route::get( '/admin/login', [LoginController::class,"showLoginForm"])->name('admin.login');
Route::post( '/admin/login', [LoginController::class,"login"])->name('admin.post.login');
Route::post( '/admin/logout', [LoginController::class,"logout"])->name('admin.logout');

Route::get( '/get/categories', [HomeController::class,"get_categories"]);
Route::get( '/get/regions', [HomeController::class,"get_regions"]);
Route::get( '/get/products', [HomeController::class,"get_products"]);
Route::get( '/get/subCategories/{id}', [HomeController::class,"get_sub_categories"]);



Route::group(['prefix' =>'/admin', 'as' => 'admin.', 'middleware' => 'admin:admin,/admin/login'],static function() {

    Route::get( '/home', [HomeController::class,"home"])->name('home');
    Route::get( '/edit-profile', [AdminController::class,"editProfile"])->name('edit-profile');
    Route::post( '/update-profile', [AdminController::class,"updateProfile"])->name('update-profile');
    Route::get( '/change-password', [AdminController::class,"changePassword"])->name('change-password');
    Route::post( '/update-password', [AdminController::class,"updatePassword"])->name('update-password');
    Route::get( '/products/index-type/{type}', [ProductController::class,"index_type"])->name('products.index-type');

    Route::get( '/dealers/new-dealer', [DealerController::class,"dealer_request"])->name('dealers.new-dealer');

    Route::resource( 'users', UserController::class ,['except' => ['destroy']]);
    Route::resource( 'dealers', DealerController::class ,['except' => ['destroy']]);
    Route::resource( 'roles', RoleController::class ,['except' => ['show', 'destroy']]);
    Route::resource('admins', AdminController::class, ['except' => 'destroy']);
    Route::resource('categories', CategoryController::class, ['except' => 'destroy']);
    Route::resource('contacts', ContactController::class, ['except' => 'destroy']);
    Route::resource('cities', CityController::class, ['except' => 'destroy']);
    Route::resource('regions', RegionController::class, ['except' => 'destroy']);
    Route::resource('sub-categories', SubCategoryController::class, ['except' => 'destroy']);
    Route::resource('sliders', SliderController::class, ['except' => 'destroy']);
    Route::resource('questions', QuestionController::class, ['except' => 'destroy']);
    Route::resource('contacts', ContactController::class, ['except' => 'destroy']);
    Route::resource('products', ProductController::class, ['except' => 'destroy']);
    Route::resource('coupons', CouponsController::class, ['except' => 'destroy']);
    Route::resource('banks', BankController::class, ['except' => 'destroy']);
    Route::resource('payment-methods', PaymentMethodController::class, ['except' => 'destroy']);
    Route::resource('posts', PostController::class, ['except' => 'destroy']);
    Route::resource('banksTransfer', BankTransferController::class, ['except' => 'destroy']);
    Route::resource('pulls', PullController::class, ['except' => 'destroy']);

//    Route::get( '/pulls/view-confirm/{pull}', [PullController::class,"view_confirm_transfer"])->name('pulls.view-confirm');

    Route::post( '/pulls/confirm-transfer', [PullController::class,"confirm_transfer"])->name('pulls.confirm-transfer');


    Route::post( '/banksTransfer/confirm-transfer', [BankTransferController::class,"confirm_transfer"])->name('banksTransfer.confirm-transfer');
    Route::post( '/banksTransfer/dont-transfer', [BankTransferController::class,"dont_transfer"])->name('banksTransfer.dont-transfer');
    Route::get( '/orders/{status}/{type}', [OrderController::class,"index"])->name('orders.index');
    Route::get( '/orders/{order}', [OrderController::class,"show"])->name('orders.show');
    Route::get( '/orders-details/{order}', [OrderController::class,"orders_details"])->name('orders.orders-details');
    Route::get( '/change-status-order/{order}', [OrderController::class,"change_status_order"])->name('orders.change-status-order');
    Route::post( '/change-status-update-order/{order}', [OrderController::class,"change_status_order_update"])->name('orders.change-status-update-order');

    Route::get( '/comments/posts-comments/{post}', [PostController::class,"posts_comments"])->name('comments.posts-comments');
    Route::post( '/comments/destroy', [PostController::class,"comments_destroy"])->name('comments.destroy');
    Route::post( '/posts/destroy', [PostController::class,"destroy"])->name('posts.destroy');

    //payment-methods
    Route::post( '/payment-methods/change-status', [PaymentMethodController::class,"changeStatus"])->name('payment-methods.change-status');
    Route::post( '/payment-methods/destroy', [PaymentMethodController::class,"destroy"])->name('payment-methods.destroy');


    // coupons
    Route::get( '/coupons/expired/coupons', [CouponsController::class,"expired_coupons"])->name('coupons.expired-coupons');
    Route::post( '/coupons/change-status', [CouponsController::class,"changeStatus"])->name('coupons.change-status');
    Route::post( '/coupons/destroy', [CouponsController::class,"destroy"])->name('coupons.destroy');

    //banks
    Route::post( '/banks/destroy', [BankController::class,"destroy"])->name('banks.destroy');
    //products
    Route::post( '/products/change-special', [ProductController::class,"changeSpecial"])->name('products.change-special');
    Route::post( '/products/change-special', [ProductController::class,"changeSpecial"])->name('products.change-special');
    Route::get( '/products/products-details/{product}', [ProductController::class,"products_details"])->name('products.products-details');
    Route::get( '/products/activate-product/{id}', [ProductController::class,"activate_product"])->name('products.activate-product');
    Route::post( '/products/destroy-image', [ProductController::class,"destroy_image"])->name('products.destroy-image');
    Route::post( '/products/destroy', [ProductController::class,"destroy"])->name('products.destroy');

    //settings
    Route::get( '/settings', [SettingController::class,"index"])->name('settings.index');
    Route::get( '/settings/order-emails', [SettingController::class,"emails"])->name('settings.order-emails');
    Route::patch( '/settings/update/{setting}', [SettingController::class,"update"])->name('settings.update');
    Route::patch( '/settings/update-email/{setting}', [SettingController::class,"update_email"])->name('settings.update-email');
    //contacts

    Route::post( '/contacts/reply/{id}', [ContactController::class,"replyMessage"])->name('contacts.reply');
    Route::post( '/contacts/destroy', [ContactController::class,"destroy"])->name('contacts.destroy');
    Route::post( '/questions/destroy', [QuestionController::class,"destroy"])->name('questions.destroy');
    Route::post( '/sliders/destroy', [SliderController::class,"destroy"])->name('sliders.destroy');
    Route::post( '/sub-categories/destroy', [SubCategoryController::class,"destroy"])->name('sub-categories.destroy');
    Route::post( '/categories/destroy', [CategoryController::class,"destroy"])->name('categories.destroy');
    Route::post( '/regions/destroy', [RegionController::class,"destroy"])->name('regions.destroy');
    Route::get( '/cities/regions/{city}', [CityController::class,"regions"])->name('cities.regions');
    Route::post( '/cities/destroy', [CityController::class,"destroy"])->name('cities.destroy');


    Route::post( '/notifications/store/{userType}', [NotificationController::class,"store"])->name('notifications.store');


    Route::get( '/notifications/create/{userType}', [NotificationController::class,"create"])->name('notifications.create');

//    Route::resource('rates', RateController::class, ['except' => 'destroy']);
//    Route::resource('banksTransfer', BankTransferController::class, ['except' => 'destroy']);
//
//    Route::get( '/pulls/view-confirm/{pull}', [PullController::class,"view_confirm_transfer"])->name('pulls.view-confirm');
//
//    Route::post( '/pulls/confirm-transfer/{pull}', [PullController::class,"confirm_transfer"])->name('pulls.confirm-transfer');
//    Route::post( '/banksTransfer/confirm-transfer', [BankTransferController::class,"confirm_transfer"])->name('banksTransfer.confirm-transfer');
//    Route::post( '/banksTransfer/dont-transfer', [BankTransferController::class,"dont_transfer"])->name('banksTransfer.dont-transfer');
//    Route::post( '/rates/destroy', [RateController::class,"destroy"])->name('rates.destroy');
//    // employees



    Route::post( '/admins/destroy', [AdminController::class,"destroy"])->name('admins.destroy');
    /*contacts*/
    Route::post( '/contacts/reply/{id}', [ContactController::class,"replyMessage"])->name('contacts.reply');
    Route::post( '/contacts/destroy', [ContactController::class,"destroy"])->name('contacts.destroy');






    // users
    Route::get( '/users/user-orders/{user}', [UserController::class,"user_orders"])->name('users.user-orders');
    Route::get( '/users/change-password/{user}', [UserController::class,"showChangePasswordForm"])->name('users.change-password');

    Route::post( '/users/change-password/{user}', [UserController::class,"updatePassword"])->name('users.post.change-password');

    Route::post( '/users/change-status', [UserController::class,"changeStatus"])->name('users.change-status');

    Route::post( '/users/destroy', [UserController::class,"destroy"])->name('users.destroy');




    Route::get( '/dealers/user-orders/{dealer}', [DealerController::class,"user_orders"])->name('dealers.user-orders');
    Route::get( '/dealers/change-password/{dealer}', [DealerController::class,"showChangePasswordForm"])->name('dealers.change-password');

    Route::post( '/dealers/change-password/{dealer}', [DealerController::class,"updatePassword"])->name('dealers.post.change-password');

    Route::post( '/dealers/change-status', [DealerController::class,"changeStatus"])->name('dealers.change-status');

    Route::post( '/dealers/destroy', [DealerController::class,"destroy"])->name('dealers.destroy');




    //settings
//    Route::get( '/settings', [SettingController::class,"index"])->name('settings.index');
//    Route::patch( '/settings/update/{setting}', [SettingController::class,"update"])->name('settings.update');
//
//


    //roles
    Route::post( '/roles/destroy', [RoleController::class,"destroy"])->name('roles.destroy');

    Route::get( '/roles/{role}/permissions', [PermissionController::class,"rolePermissions"])->name('roles.permissions');


    //admins
    Route::get( '/admins/{admin}/permissions', [PermissionController::class,"adminPermissions"])->name('admins.permissions');

    Route::post( '/admins/{admin}/permissions/edit', [PermissionController::class,"editAdminPermissions"])->name('admins.permissions.edit');


    Route::post( '/admins/change-status', [AdminController::class,"changeStatus"])->name('admins.change-status');

    Route::get( '/admins/change-password/{admin}', [AdminController::class,"showChangePasswordForm"])->name('admins.change-password');


    Route::post( '/admins/change-password/{admin}', [AdminController::class,"updateAdminPassword"])->name('admins.post.change-password');


    Route::post( '/notifications/store/{userType}', [NotificationController::class,"store"])->name('notifications.store');


    Route::get( '/notifications/create/{userType}', [NotificationController::class,"create"])->name('notifications.create');
    Route::post( 'delete-all-notification', [NotificationController::class,"delete_all_notification"])->name('notifications.delete-all-notification');
    Route::post( 'delete-count', [NotificationController::class,"delete_count"])->name('notifications.delete-count');
    Route::get( '/notifications/index', [NotificationController::class,"index"])->name('notifications.index');
    Route::post( '/notifications/destroy', [NotificationController::class,"destroy"])->name('notifications.destroy');
    Route::get( '/notifications/delete-all', [NotificationController::class,"delete_all"])->name('notifications.delete-all');





});
