<?php

namespace App\Http\Controllers\Admin;

use App\Models\Cart;
use App\Models\Region;
use App\Http\Requests\Admin\CityRequest;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CityController extends Controller
{
    public function index()
    {
        $this->authorize('view_regions', Region::class);
        $data = Region::whereParentId(null)->orderBy('id', 'DESC')->paginate(10);

        return view('admin.cities.index', compact('data'));
    }

    public function regions(Region $city)
    {
        $this->authorize('view_regions', Region::class);
        $data = Region::whereParentId($city->id)->orderBy('id', 'DESC')->paginate(10);

        return view('admin.regions.index', compact('data','city'));
    }


    public function create()
    {
        $this->authorize('create_regions', Region::class);

        return view('admin.cities.create');
    }

    public function store(CityRequest $request) {

        $this->authorize('create_regions', Region::class);

        $request['country_id']=1;
        $data = Region::create($request->all());

        return $data ?
            redirect()->route('admin.cities.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.cities.index')->with('warning', trans('messages.addNO'));
    }

    public function edit(Region $city) {

        $this->authorize('edit_regions', $city);
        return view('admin.cities.edit', compact('city'));
    }

    public function update(CityRequest $request, Region $city) {

        $this->authorize('edit_regions', $city);


        $data = $city->update($request->all());


        return $data ?
            redirect()->route('admin.cities.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.cities.index')->with('warning', trans('messages.updateNO'));
    }

    public function destroy(Request $request) {

        $data = Region::find($request->id);

        if( $data->regions()->count() > 0)
            return json_encode(['code' => '2', 'message' =>trans('messages.cant_delete')]);

        Cart::where('region_id',$data->id)->orWhere('city_id',$data)->delete();
        $deleted = $data->delete();
        $url = route('admin.cities.index');

        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }

}
