<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\DealerRequest;
use App\Http\Resources\Dealer\WalletResource;
use App\Models\Order;
use App\Models\OrderProduct;
use App\Models\Product;
use App\Models\Region;
use App\Models\User;
use App\Models\UserDevice;
use App\Models\UserWallet;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Image;

class DealerController extends Controller
{
    public function index()
    {
        $this->authorize('view_users', User::class);
        $data = User::whereUserType('dealer')->orderBy('id', 'DESC')->paginate(10);

        return view('admin.dealers.index', compact('data'));
    }
    public function dealer_request()
    {
        $this->authorize('view_users', User::class);
        $data = User::whereUserType('dealer')->whereApproved(0)->orderBy('id', 'DESC')->paginate(10);

        return view('admin.dealers.dealer_request', compact('data'));
    }

    public function show(User $dealer) {

        $this->authorize('show_users', $dealer);
        $sales_number = OrderProduct::whereHas('products',function ($q){
            $q->where('user_id',\request()->user()->id);
        })->whereHas('order',function ($q2){
            $q2->where('status','done');
        })->count();
        $total = Order::where('status','done')->whereHas('products',function ($q){
            $q->whereHas('products',function ($q2){
                $q2->where('user_id',\request()->user()->id);
            });
        })->sum('all_total');
        $sales_price = $total - ($total * \request()->user()->app_percentage /100);

        $app_price = $total * \request()->user()->app_percentage /100;
        $regionChoose = $dealer->regions()->pluck('region_id')->toArray();
        $citiesChoose = Region::whereIn('id',$regionChoose)->pluck('parent_id')->toArray();
        $cities = Region::whereIn('id',$citiesChoose)->get();
        $data = Product::whereStatus(0)->whereUserId($dealer->id)->where('type','product')->orderBy('id', 'DESC')->paginate(20);

        return view('admin.dealers.show', compact('dealer','sales_number'
        ,'sales_price','app_price','cities','regionChoose','data'));
    }

    public function user_orders(User $dealer) {

        $this->authorize('show_users', $dealer);
        $data = Order::whereHas('products',function ($q) use($dealer){
            $q->whereHas('products',function ($q2) use($dealer){
                $q2->where('user_id',$dealer->id);
            });
        })->orderBy('id','desc')->paginate(10);
        return view('admin.dealers.user_orders', compact('dealer','data'));
    }
    public function change_status_order(Order $order) {

        $this->authorize('activate_orders', Order::class);
        $dealer = User::find($order->user_id);

        return view('admin.dealers.change_status_orders', compact('order','dealer'));
    }
    public function products_order(Order $order) {

        $this->authorize('show_orders', Order::class);
        $dealer = User::find($order->user_id);
        $data= $order->products()->get();
        return view('admin.dealers.products_order', compact('order','dealer','data'));
    }
    public function change_status_order_update(Request $request ,Order $order) {

        $this->authorize('activate_orders', Order::class);

        $data = $order->update($request->all());


        return $data ?
            redirect()->route('admin.dealers.user-orders',$order->user_id)->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.dealers.user-orders',$order->user_id)->with('warning', trans('messages.updateNO'));
    }
    public function create()
    {
        $this->authorize('create_users', User::class);
        $cities = Region::whereParentId(null)->orderBy('id', 'DESC')->get();
        return view('admin.dealers.create',compact('cities'));
    }

    public function store(DealerRequest $request) {

        $this->authorize('create_users', User::class);

        if ( isset($request->photo) && $request->photo ){
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $request['height']=$height;
            $request['width']=$width;
            $request['image'] = UploadImage($request->file('photo'), 'users', '/uploads/users');

        }


        $request['language']="ar";
        $request['user_type']="dealer";
        $request['active']=1;
        $request['approved']=1;
        $data = User::create($request->all());
        $data->regions()->sync( $request->region_id );

        return $data ?
            redirect()->route('admin.dealers.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.dealers.index')->with('warning', trans('messages.addNO'));
    }

    public function edit(User $dealer) {

        $this->authorize('edit_users', $dealer);
        $cities = Region::whereParentId(null)->orderBy('id', 'DESC')->get();
        $regionChoose = $dealer->regions()->pluck('region_id')->toArray();
        $citiesChoose = Region::whereIn('id',$regionChoose)->pluck('parent_id')->toArray();
        return view('admin.dealers.edit', compact('dealer','cities','regionChoose','citiesChoose'));
    }

    public function update(DealerRequest $request, User $dealer) {

        $this->authorize('edit_users', $dealer);
        if ( isset($request->photo) && $request->photo ){
            @unlink(public_path('uploads/users/') . $dealer->image);
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $request['height']=$height;
            $request['width']=$width;
            $request['image'] = UploadImage($request->file('photo'), 'users', '/uploads/users');
        }
        if ($dealer->approved == 0){
            $notificationTitle = array(
                'ar'=>"تفعيل الحساب",
                'en'=>"Activate the account",
            );
            $notificationMessage = array(
                'ar'=>"تم تفعيل الحساب الخاص بك",
                'en'=>"Your account has been activated",

            );
            $all_data = array(
                'title'=>"تفعيل الحساب",
                'body'=>"تم تفعيل الحساب الخاص بك",
                'type'=>6,
                'seen'=>0,
                'notifiable_id'=>$dealer->id,
                'sound' => 'default',
//                    'click_action' => 'FCM_PLUGIN_ACTIVITY',
            );
            saveNotification($dealer->id, 6, serialize($notificationTitle), serialize($notificationMessage) );

            $devicesTokens  = UserDevice::where('user_id', $dealer->id)
                ->orderBy('updated_at', 'DESC')
                ->pluck('firebase_token')
                ->toArray();
            if($devicesTokens)
                sendMultiNotification($all_data, $devicesTokens);
        }
        $request['active']=1;
        $request['approved']=1;
        $data = $dealer->update($request->all());
        $dealer->regions()->sync( $request->region_id );

        return $data ?
            redirect()->route('admin.dealers.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.dealers.index')->with('warning', trans('messages.updateNO'));
    }

    public function destroy(Request $request) {

        $data = User::find($request->id);
        @unlink(public_path('uploads/users/') . $data->image);
        $deleted = $data->delete();
        $url = route('admin.dealers.index');

        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
    public function changeStatus(Request $request){

        $updated = User::where('id', $request->id)->update(['active' => $request->status]);
        if ($request->status == 0){
            Auth::guard('web')->setUser(User::find($request->id));
            Auth::guard('web')->logout(User::find($request->id));
        }
        $url = route('admin.dealers.index');

        return $updated
            ? json_encode(['code'=> '1', 'url'=> $url])
            : json_encode(['code'=> '0', 'message'=> 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
    public function showChangePasswordForm(User $dealer) {

        return view('admin.dealers.change_password', compact('dealer'));
    }

    public function updatePassword(Request $request, User $dealer) {

        $request->validate([
            'new_password'      => 'required|min:3|max:191',
            'password_confirm'  => 'same:new_password',
        ]);

        $updated = $dealer->update(['password' => $request->new_password]);
        return $updated ?
            redirect()->route('admin.dealers.index')->with('success', 'تم تغيير كلمة مرور العضو بنجاح') :
            redirect()->route('admin.dealers.index')->with('warning', 'حدث خطأ ما, برجاء المحاولة مرة اخرى');
    }
}
