<?php

namespace App\Http\Controllers\Admin;



use App\Models\Admin;
use App\Models\Category;
use App\Models\Contact;
use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\OrderProduct;
use App\Models\Permission;
use App\Models\Product;
use App\Models\Region;
use App\Models\Role;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class HomeController extends Controller
{

    public function home() {
        $today      = Carbon::today()->toDateString();
        $todayDate  = strtotime($today);
        $start      = (date('w', $todayDate) == 6) ? $todayDate : strtotime('last saturday', $todayDate);
        $weekStart  = date('Y-m-d', $start);
        $weekEnd    = date('Y-m-d', strtotime('next saturday', $start));
        $monthStart = date('Y-m-01', strtotime($today));
        $monthEnd   = date('Y-m-t', strtotime($today));


        $admins= Admin::count();

        $ordersNew = Order::where('status','new')->count();
        $ordersIn_progress = Order::where('status','in_progress')->count();
        $ordersDone = Order::where('status','done')->count();
        $ordersDoneMonth = OrderProduct::whereDate('created_at', '>=', $monthStart)->whereDate('created_at', '<=', $monthEnd)->count();
        $ordersDoneWeek = OrderProduct::whereDate('created_at', '>=', $weekStart)->whereDate('created_at', '<=', $weekEnd)->count();
        $ordersDoneDay = OrderProduct::whereDate('created_at', '=', $today)->count();
        $allProducts = Product::whereStatus(0)->where('type','product')->count();
        $allOrdersSales = OrderProduct::count();
        $allOrders = Order::count();
        $categories = Category::whereParentId(null)->count();
        $SubCategories = Category::where('parent_id','!=',null)->count();
        $offerProduct = Product::where('discount','!=',null)->whereStatus(0)->where('type','product')->count();


        $ordersDoneMonthTotal = Order::whereStatus('done')->whereDate('created_at', '>=', $monthStart)->whereDate('created_at', '<=', $monthEnd)->sum('all_total');

        $ordersDoneWeekTotal =  Order::whereStatus('done')->whereDate('created_at', '>=', $weekStart)->whereDate('created_at', '<=', $weekEnd)->sum('all_total');

        $ordersDoneDayTotal =   Order::whereStatus('done')->whereDate('created_at', '=', $today)->sum('all_total') ;

        $allOrdersSalesTotal =  Order::whereStatus('done')->sum('all_total');

        return view('admin.dashboard.home',compact('admins','ordersDoneMonth','ordersDoneWeek','ordersDoneDay','allProducts',
            'allOrders','ordersNew','ordersDone','ordersIn_progress','categories','SubCategories'
        ,'allOrdersSales' ,'ordersDoneDayTotal','offerProduct'
        ,'ordersDoneMonthTotal','ordersDoneWeekTotal','allOrdersSalesTotal'));

    }

    public function statistics() {

        //

        $chartMonth = [
            'chart_title' => 'Sales by month',
            'report_type' => 'group_by_date',
            'model' => 'App\Order',
            'group_by_field' => 'created_at',
            'group_by_period' => 'month',
            'filter_days' => 30, // show only transactions for last 30 days
            'chart_type' => 'line',
            'style_class' => 'custom-width',
            'conditions'            => [
            ['name' => 'عدد الطلبات المنتهية شهريا', 'condition' => 'status = "done"', 'color' => 'gray'],
                ['name' => 'عدد الطلبات الجديدة شهريا', 'condition' => 'status = "new"', 'color' => 'blue'],
        ],
        ];
        $chartWeek = [
            'chart_title' => 'Sales by week',
            'report_type' => 'group_by_date',
            'model' => 'App\Order',
            'group_by_field' => 'created_at',
            'group_by_period' => 'week',
            'filter_days' => 30, // show only transactions for last 30 days
            'chart_type' => 'line',
            'date_format'=>'Y-m-d',
            'style_class' => 'custom-width',
            'conditions'            => [
                ['name' => 'عدد الطلبات المنتهية اسبوعيا', 'condition' => 'status = "done"', 'color' => 'green'],
                ['name' => 'عدد الطلبات الجديدة اسبوعيا', 'condition' => 'status = "new"', 'color' => 'blue'],
            ],
        ];
        $chartYear = [
            'chart_title' => 'Sales by year',
            'report_type' => 'group_by_date',
            'model' => 'App\Order',
            'group_by_field' => 'created_at',
            'group_by_period' => 'year',
            'chart_type' => 'line',
            'style_class' => 'custom-width',
            'conditions'            => [
                ['name' => 'عدد الطلبات المنتهية سنويا', 'condition' => 'status = "done"', 'color' => 'purple'],
                ['name' => 'عدد الطلبات الجديدة سنويا', 'condition' => 'status = "new"', 'color' => 'blue'],
            ],
        ];
        $chart1 = new LaravelChart($chartMonth);
        $chart2 = new LaravelChart($chartWeek);
        $chart3 = new LaravelChart($chartYear);

        return view('admin.dashboard.statistics', compact('chart1','chart2','chart3'));

//        return view('admin.dashboard.statistics',compact('chartMonth','chartWeek','chartYear','dataPoints'));
    }
    public function get_categories(){

        $categories =Category::select('id','name')->whereParentId(null)->get();
        $categories->map(function ($all) {
            $all['name']=$all->name['ar'];
            return $all;
        });
        $data['categories']= $categories;
        return json_encode($data);

    }
    public function get_products(){

        $products = Product::select('id','title')->where('type','product')->get();
        $products->map(function ($all) {
            $all['name']=$all->title['ar'];
            return $all;
        });
        $data['products']= $products;
        return json_encode($data);

    }
    public function get_sub_categories($id){

        $categories = Category::select('id','name')->whereParentId($id)->get();
        $categories->map(function ($all) {
            $all['name']=$all->name['ar'];
            return $all;
        });


        $data['categories']= $categories;
        return json_encode($data);

    }
    public function get_regions(Request $request){

        $regions = Region::select('id','name')->whereIn('parent_id',$request->ids)->get();
        $regions->map(function ($all) {
            $all['name']=$all->name['ar'];
            return $all;
        });


        $data['regions']= $regions;
        return json_encode($data);

    }
}
