<?php

namespace App\Http\Controllers\Admin;

use App\Models\Admin;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class PermissionController extends Controller
{

    public function rolePermissions(Role $role) {

        $this->authorize('edit_permissions', Permission::class);

        $rolePermissions= $role->permissions()->pluck('id')->toArray();
        $allPermissions = Permission::orderBy('table_name', 'ASC')->get();
        $data           = $this->getPermissions($allPermissions);

        return view('admin.permissions.role_permissions', compact('data', 'role', 'rolePermissions'));
    }

    public function adminPermissions(Admin $admin) {

        $this->authorize('edit_permissions', Permission::class);

        $adminPermissions   = $admin->permissions()->pluck('id')->toArray();
        $allPermissions     = Permission::orderBy('table_name', 'ASC')->get();
        $data               = $this->getPermissions($allPermissions);

        return view('admin.permissions.admin_permissions', compact('data', 'admin', 'adminPermissions'));
    }

    public function editAdminPermissions(Request $request, Admin $admin) {

        $this->authorize('edit_permissions', Permission::class);

        $this->validate($request, [
            'permissions' => 'required',
        ]);

        if ( $admin->id != 1 && $admin->id != Auth::guard('admin')->user()->id ) {

            $updated = $admin->permissions()->sync($request->permissions);
            return $updated ?
                redirect()->route('admin.admins.index')->with('success', trans('messages.updateOK')) :
                redirect()->route('admin.admins.create')->with('warning', trans('messages.updateNO'));
        }
        abort('403');
    }

    protected function getPermissions($permissions) {

        $data = [];
        foreach ($permissions as $key => $permission) {

            end($data);
            $last_key = key($data);

            if( $key > 0 && count($data) > 0) {

                if( $permission->table_name == key($data[$last_key]) ) {

                    $data[$last_key][$permission->table_name][] = $permission;
                }
                else {
                    array_push( $data, array($permission->table_name => [$permission]) );
                }
            }
            else {
                array_push( $data, array($permission->table_name => [$permission]) );
            }
        }
        return $data;
    }
}
