<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Comment;
use App\Models\Post;
use Illuminate\Http\Request;

class PostController extends Controller
{
    //
    public function index()
    {
        $this->authorize('view_posts', Post::class);
        $data = Post::orderBy('id', 'DESC')->paginate(10);

        return view('admin.posts.index', compact('data'));
    }
    public function posts_comments(Post $post)
    {

        $data =$post->comments()->paginate(10);

        return view('admin.posts.comments', compact('data'));
    }
    public function destroy(Request $request) {

        $data = Post::find($request->id);
        if (isset($data->image) && $data->image != '') {
            @unlink(public_path('uploads/posts/') . $data->image);
        }
        $deleted = $data->delete();

        $url = route('admin.posts.index');

        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
    public function comments_destroy(Request $request) {

        $data = Comment::find($request->id);
        if (isset($data->image) && $data->image != '') {
            @unlink(public_path('uploads/posts/') . $data->image);
        }
        $url = route('admin.comments.posts-comments',$data->post_id);
        $deleted = $data->delete();



        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
}
