<?php

namespace App\Http\Controllers\Admin;


use App\Models\Cart;
use App\Models\Category;
use App\Http\Requests\Admin\ProductRequest;
use App\Models\Product;
use App\Models\ProductImage;
use App\Models\Setting;
use App\Models\User;
use App\Models\UserDevice;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Image;

class ProductController extends Controller
{
    //
    public function index( )
    {
        $this->authorize('view_products', Product::class);
        $data = Product::whereStatus(0)->where('type','product')->orderBy('id', 'DESC')->paginate(10);

        return view('admin.products.index', compact('data'));
    }
    public function index_type($type)
    {
        $this->authorize('view_products', Product::class);
        if ($type == "sold"){

            $data =   Product::whereStatus(0)->where('type','product')->where('sold','!=',0)->orderBy('sold','desc')
                ->paginate(12);
        }elseif ($type == "new"){
            $data = Product::orderBy('id', 'DESC')->where('type','product')->whereStatus(0)->take(20)->paginate(10);
        }elseif ($type == "offer"){
            $data = Product::where('discount','!=',null)->where('type','product')->whereStatus(0)->orderBy('id', 'DESC')->paginate(10);
        }elseif ($type == "special"){
            $data = Product::whereStatus(0)->where('type','product')->where('special',1)->orderBy('id', 'DESC')->paginate(10);
        }else{
            $data = Product::orderBy('id', 'DESC')->where('type','product')->whereStatus(0)->paginate(10);
        }


        return view('admin.products.index', compact('data'));
    }

    public function show( $product) {

       $product= Product::withTrashed()->find($product);
        $this->authorize('show_products', $product);

        return view('admin.products.show', compact('product'));
    }

    public function create()
    {
        $this->authorize('create_products', Product::class);
        $categories = Category::whereParentId(null)->get();
        $users = User::whereUserType('dealer')->get();

        return view('admin.products.create',compact('categories','users'));
    }

    public function store(ProductRequest $request) {

        $this->authorize('create_products', Product::class);
//        dd($request->all());
//

        if ($request->discount != null){
            $request['after_discount'] = $request->price - ($request->price * $request->discount /100);
        }else{
            $request['after_discount'] = $request->price;
        }


        $created=Product::create($request->all());

        if ( isset($request->photos) && $request->photos ){

            foreach ($request->photos as $data){
                $upload_file =$data;
                $height = Image::make($upload_file)->height();
                $width = Image::make($upload_file)->width();
                $image = UploadImage($data, 'products', '/uploads/products');
                $file = new ProductImage();
                $file->product_id = $created->id;
                $file->height = $height;
                $file->width = $width;
                $file->image = $image;
                $file->save();
            }
        }
        if (isset($request->send_notification) && $request->send_notification == 1){
            /*send notifications*/
            $notificationTitle = array(
                'ar'=>"منتج جديد",
                'en'=>'A new product ',
            );
            $notificationMessage = array(
                'ar'=>"تم اضافة منتج جديد ".$request->title['ar'],
                'en'=>"A new product has been added ".$request->title['en'],

            );
            $category = Category::find($request->category_id);
            $sub_category = Category::find($request->sub_category_id);
            $all_data_ar = array(
                'title'=>'تم إضافة منتج '.$request->title['ar'],
                'body'=>$sub_category !== null ? 'في القسم '.$category->name['ar'].' /'.$sub_category->name['ar'] :  'في القسم '.$category->name['ar'],
//                'image_path'=>'/uploads/products/',
                'image'=>url('/').'/uploads/products/'.ProductImage::where('product_id',$created->id)->first()->image,
                'type'=>2,
                'seen'=>0,
                'notifiable_id'=>$created->id,
                'sound' => 'default',
//                'click_action' => 'FCM_PLUGIN_ACTIVITY',
            );

            $all_data_en = array(
                'title'=>'A product '.$request->title['en'].' has been added',
                'body'=>$sub_category !== null ? 'In Category ' .$category->name['en'].'/'.$sub_category->name['en'] : 'In Category ' .$category->name['en'],
//                'image_path'=>'/uploads/products/',
                'image'=>url('/').'/uploads/products/'.ProductImage::where('product_id',$created->id)->first()->image,
                'type'=>2,
                'seen'=>0,
                'notifiable_id'=>$created->id,
                'sound' => 'default',
//                'click_action' => 'FCM_PLUGIN_ACTIVITY',
            );


            $usersIds       = User::get()->pluck('id')->toArray();
            foreach ($usersIds as $id)
                saveOrderNotification($id, 2, serialize($notificationTitle) , serialize($notificationMessage) ,$created->id,'App\Product' );

            sendTopicNotification($all_data_ar,'all_users_ar');
            sendTopicNotification($all_data_en,'all_users_en');
            /*end notifications*/


        }

        return $created ?
            redirect()->route('admin.products.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.products.index')->with('warning', trans('messages.addNO'));
    }

    public function edit(Product $product) {

        $this->authorize('edit_products', $product);
        $categories = Category::whereParentId(null)->get();
        $users = User::whereUserType('dealer')->get();
        $images = $product->images()->get();
        return view('admin.products.edit',compact('product','categories','users','images'));
    }




    public function update(ProductRequest $request, Product $product) {

        $this->authorize('edit_products', $product);


        if ($request->discount != null){
            $request['after_discount'] = $request->price - ($request->price * $request->discount /100);
        }else{
            $request['after_discount'] = $request->price;
        }
        Cart::where('product_id',$product->id)->update([
            'range'=>$request->range
        ]);
        $updated=$product->update($request->all());

        if ( isset($request->photos) && $request->photos ){

            foreach ($request->photos as $data){
                $upload_file =$data;
                $height = Image::make($upload_file)->height();
                $width = Image::make($upload_file)->width();
                $image = UploadImage($data, 'products', '/uploads/products');
                $file = new ProductImage();
                $file->product_id = $product->id;
                $file->image = $image;
                $file->height = $height;
                $file->width = $width;
                $file->save();
            }
        }


        return $updated ?
            redirect()->route('admin.products.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.products.index')->with('warning', trans('messages.updateNO'));
    }



    public function destroy(Request $request) {

        $data = Product::find($request->id);
//        $OrderProduct = OrderProduct::where('product_id',$data->id)->get();


//        if( $data->categories()->count() > 0)
//            return json_encode(['code' => '2', 'message' => trans('messages.cant_delete')]);

//        if(count($OrderProduct) > 0){
//            $data->update(['status'=>1]);
//            $url = route('admin.products.index');
//            return json_encode(['code' => '1', 'url' => $url]);
//        }

        foreach ($data as $value){
            foreach(ProductImage::where('product_id',$value)->get() as $all){
                @unlink(public_path('uploads/products/') . $all->image);
            }

        }

        $url = route('admin.products.index');
        $deleted = $data->delete();


        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }

    public function destroy_image(Request $request) {

        $data = ProductImage::find($request->id);

        @unlink(public_path('uploads/products/') . $data->image);
        $url = route('admin.products.edit',$request->product_id);
        $deleted = $data->delete();


        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
    public function activate_product($id ,Request $request) {

        $data = Product::find($id)->update(['active'=>$request->active]);

        return  json_encode(['code' => '1']);
    }

    //==============================================================================
    public function products_details( Product $product)
    {
        $this->authorize('show_products', Product::class);
        $data = Product::whereStatus(0)->orderBy('id', 'DESC')->paginate(10);

        return view('admin.products.index', compact('data'));
    }
    public function changeSpecial(Request $request ) {

        $updated = Product::where('id', $request->id)->update(['special' => $request->special]);
        $url = route('admin.products.index');

        return $updated
            ? json_encode(['code'=> '1', 'url'=> $url])
            : json_encode(['code'=> '0', 'message'=> 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }

}
