<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\UserDevice;
use App\Models\UserWallet;
use Illuminate\Http\Request;

class PullController extends Controller
{
    public function index()
    {
        $this->authorize('view_user_wallets', UserWallet::class);
        $data = UserWallet::where('status',\request()->status)->orderBy('id','desc')->paginate(10);

        return view('admin.pulls.index',compact('data'));
    }
    public function view_confirm_transfer(UserWallet $pull)
    {
        $this->authorize('view_user_wallets', UserWallet::class);

        $user = User::find($pull->user_id);

        return view('admin.pulls.view_confirm_transfer',compact('pull','user'));
    }
    public function confirm_transfer(Request $request) {

        $data = UserWallet::find($request->id);
        $dealer = User::find($data->user_id);

        $dealer->update(['wallet'=>$dealer->wallet - $data->balance,

        ]);


        $data->update([
            'status'=> "approved",
        ]);
        $new = UserWallet::find($data->id);
        $url = route('admin.pulls.index','type='.$new->status);
        $notificationTitle = array(
            'ar'=>" تم تحويل المستحقات من اداره التطبيق",
            'en'=>"The receivables have been transferred from the application department",
        );
        $notificationMessage = array(
            'ar'=> " تم تحويل المستحقات من اداره التطبيق",
            'en'=>"The receivables have been transferred from the application department",

        );
        $all_data = array(
            'title'=>" تم تحويل المستحقات من اداره التطبيق",
            'body'=> " تم تحويل المستحقات من اداره التطبيق",
            'type'=>5,
            'seen'=>0,
            'notifiable_id'=>null,
//            'click_action' => 'MAIN_ACTIVITY',
            'sound' => true,
        );

        $devicesTokens  = UserDevice::where('user_id', $data->user_id)
//                ->where('is_open', true)
            ->orderBy('updated_at', 'DESC')
            ->pluck('firebase_token')
            ->toArray();

        saveOrderNotification($data->user_id, 5, serialize($notificationTitle) , serialize($notificationMessage) ,null ,null );
        if($devicesTokens)
            sendMultiNotification($all_data, $devicesTokens);

        return $data ?
            redirect()->route('admin.pulls.index','status=approved')->with('success', "تم تأكيد التحويل بنجاح") :
            redirect()->route('admin.pulls.index','status=approved')->with('warning', trans('messages.updateNO'));

    }
}
