<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\QuestionRequest;
use App\Models\Question;
use Illuminate\Http\Request;

class QuestionController extends Controller
{
    public function index()
    {
        $this->authorize('view_questions', Question::class);
        $data = Question::orderBy('id', 'DESC')->paginate(10);

        return view('admin.questions.index', compact('data'));
    }


    public function create()
    {
        $this->authorize('create_questions', Question::class);
        return view('admin.questions.create');
    }

    public function store(QuestionRequest $request) {

        $this->authorize('create_questions', Question::class);

        $data = Question::create($request->all());

        return $data ?
            redirect()->route('admin.questions.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.questions.index')->with('warning', trans('messages.addNO'));
    }

    public function edit(Question $question) {

        $this->authorize('edit_questions', $question);

        return view('admin.questions.edit', compact('question'));
    }

    public function update(QuestionRequest $request, Question $question) {

        $this->authorize('edit_questions', $question);

        $data = $question->update($request->all());


        return $data ?
            redirect()->route('admin.questions.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.questions.index')->with('warning', trans('messages.updateNO'));
    }

    public function destroy(Request $request) {

        $data = Question::find($request->id);



        $deleted = $data->delete();
        $url = route('admin.questions.index');

        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
}
