<?php

namespace App\Http\Controllers\Admin;


use App\Http\Requests\Admin\RegionRequest;
use App\Models\Cart;
use App\Models\Region;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class RegionController extends Controller
{
    public function index()
    {
        $this->authorize('view_regions', Region::class);
        $data = Region::where('parent_id','!=',null)->orderBy('id', 'DESC')->paginate(10);

        return view('admin.regions.index', compact('data'));
    }


    public function create()
    {
        $this->authorize('create_regions', Region::class);
        $cities = Region::whereParentId(null)->get();

        return view('admin.regions.create',compact('cities'));
    }

    public function store(RegionRequest $request) {

        $this->authorize('create_regions', Region::class);

        $request['parent_id']=$request->city_id;
        $data = Region::create($request->all());

        return $data ?
            redirect()->route('admin.regions.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.regions.index')->with('warning', trans('messages.addNO'));
    }

    public function edit(Region $region) {

        $this->authorize('edit_regions', $region);
        $cities = Region::whereParentId(null)->get();
        return view('admin.regions.edit', compact('region','cities'));
    }

    public function update(RegionRequest $request, Region $region) {

        $this->authorize('edit_regions', $region);

        $request['parent_id']=$request->city_id;
        $data = $region->update($request->all());


        return $data ?
            redirect()->route('admin.regions.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.regions.index')->with('warning', trans('messages.updateNO'));
    }

    public function destroy(Request $request)
    {

        $data = Region::find($request->id);
         Cart::where('region_id',$data->id)->orWhere('city_id',$data)->delete();

//        if( $data->cities()->count() > 0)
//            return json_encode(['code' => '2', 'message' =>trans('messages.cant_delete')]);

        $deleted = $data->delete();
        $url = route('admin.regions.index');

        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
}
