<?php

namespace App\Http\Controllers\Admin;

use App\Models\Category;
use App\Http\Requests\SettingEmailRequest;
use App\Http\Requests\Admin\SettingRequest;
use App\Models\Page;
use App\Models\Product;
use App\Models\Setting;
use Cassandra\Type\Set;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SettingController extends Controller
{
    public function index() {

        $this->authorize('view_settings', Setting::class);
        $setting = Setting::find(1);
        $categories = Category::whereParentId(null)->get();
        $products = Product::get();
        $parent_id_1 = $setting->first_category_id ? Category::find($setting->first_category_id)->parent_id :'';
        $parent_id_2 = $setting->second_category_id ? Category::find($setting->second_category_id)->parent_id :'';
        return view('admin.settings.edit', compact('setting','categories'
            ,'products','parent_id_1','parent_id_2'));
    }
    public function emails() {

        $this->authorize('view_settings', Setting::class);
        $setting = Setting::find(1);

        return view('admin.settings.order_emails', compact('setting'));
    }
    public function update_email(SettingEmailRequest $request, Setting $setting) {

        $this->authorize('edit_settings', $setting);


        $data = $setting->update($request->all());


        return back()->with('success', trans('messages.updateOK')) ;
    }


    public function update(SettingRequest $request, Setting $setting) {

        $this->authorize('edit_settings', $setting);


        $data = $setting->update($request->all());


        return back()->with('success', trans('messages.updateOK')) ;
    }



}
