<?php

namespace App\Http\Controllers\Admin;


use App\Models\Category;
use App\Http\Requests\Admin\SubCategoryRequest;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Image ;
class SubCategoryController extends Controller
{
    //
    public function index( )
    {
        $this->authorize('viewSub_categories', Category::class);
        $data = Category::where('parent_id','!=',null)->orderBy('id', 'DESC')->paginate(10);

        return view('admin.sub_categories.index', compact('data'));
    }
    public function show(Category $subCategory) {

        $this->authorize('createSub_categories', $subCategory);
        return view('admin.sub_categories.show', compact('subCategory'));
    }

    public function create()
    {
        $this->authorize('createSub_categories', Category::class);

        $categories= Category::where('parent_id',null)->orderBy('id', 'DESC')->get();

        return view('admin.sub_categories.create',compact('categories'));
    }
    public function store(SubCategoryRequest $request) {

           $this->authorize('createSub_categories', Category::class);

            if ( isset($request->photo) && $request->photo ){
                $upload_file = $request->file('photo');
                $height = Image::make($upload_file)->height();
                $width = Image::make($upload_file)->width();

                $image = UploadImage($request->file('photo'), 'categories', '/uploads/categories');

            }
            $subCategory = new Category();
            $subCategory['name->ar']=$request->name_ar;
            $subCategory['name->en']=$request->name_en;
            $subCategory['parent_id']=$request->category_id;
            $subCategory['height']=isset($height)?$height:null;
            $subCategory['width']=isset($width)?$width:null;
            $subCategory['image']=isset($image) ? $image : '';
            $subCategory->save();

        return $subCategory ?
            redirect()->route('admin.sub-categories.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.sub-categories.index')->with('warning', trans('messages.addNO'));
    }


    public function edit(Category $subCategory) {

        $this->authorize('editSub_categories', $subCategory);

        $categories= Category::where('parent_id',null)->orderBy('id', 'DESC')->get();
        return view('admin.sub_categories.edit',compact('subCategory','categories'));
    }


    public function update(SubCategoryRequest $request, Category $subCategory) {

        $this->authorize('editSub_categories', $subCategory);


        if ( isset($request->photo) && $request->photo ){
            @unlink(public_path('uploads/categories/') . $subCategory->image);
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $image = UploadImage($request->file('photo'), 'categories', '/uploads/categories');

        }

        $subCategory['name->ar']=$request->name_ar;
        $subCategory['name->en']=$request->name_en;
        $subCategory['parent_id']=$request->category_id;
        $subCategory['height']=isset($height)?$height:null;
        $subCategory['width']=isset($width)?$width:null;
        $subCategory['image']=isset($image) ? $image : $subCategory->image;
        $subCategory->save();

        return $subCategory ?
            redirect()->route('admin.sub-categories.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.sub-categories.index')->with('warning', trans('messages.updateNO'));
    }



    public function destroy(Request $request) {

        $data = Category::find($request->id);

        //check-if-this-signed products
        if( $data->products()->count() > 0)
            return json_encode(['code' => '2', 'message' => trans('messages.cant_delete')]);

        $url = route('admin.sub-categories.index');
        $deleted = $data->delete();


        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }

}
