<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UserRequest;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Image;

class UserController extends Controller
{
    public function index()
    {
        $this->authorize('view_users', User::class);
        $data = User::whereUserType('user')->orderBy('id', 'DESC')->paginate(10);

        return view('admin.users.index', compact('data'));
    }

    public function show(User $user) {

        $this->authorize('show_users', $user);
        return view('admin.users.show', compact('user'));
    }

    public function user_orders(User $user) {

        $this->authorize('show_users', $user);
         $data = $user->orders()->paginate(10);
        return view('admin.users.user_orders', compact('user','data'));
    }
    public function change_status_order(Order $order) {

        $this->authorize('activate_orders', Order::class);
        $user = User::find($order->user_id);

        return view('admin.users.change_status_orders', compact('order','user'));
    }
    public function products_order(Order $order) {

        $this->authorize('show_orders', Order::class);
        $user = User::find($order->user_id);
        $data= $order->products()->get();
        return view('admin.users.products_order', compact('order','user','data'));
    }
    public function change_status_order_update(Request $request ,Order $order) {

        $this->authorize('activate_orders', Order::class);

        $data = $order->update($request->all());


        return $data ?
            redirect()->route('admin.users.user-orders',$order->user_id)->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.users.user-orders',$order->user_id)->with('warning', trans('messages.updateNO'));
    }
    public function create()
    {
        $this->authorize('create_users', User::class);

        return view('admin.users.create');
    }

    public function store(UserRequest $request) {

        $this->authorize('create_users', User::class);

        if ( isset($request->photo) && $request->photo ){
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $request['height']=$height;
            $request['width']=$width;
            $request['image'] = UploadImage($request->file('photo'), 'users', '/uploads/users');

        }


        $request['language']="ar";
        $request['user_type']="user";
        $data = User::create($request->all());

        return $data ?
            redirect()->route('admin.users.index')->with('success', trans('messages.addOK')) :
            redirect()->route('admin.users.index')->with('warning', trans('messages.addNO'));
    }

    public function edit(User $user) {

        $this->authorize('edit_users', $user);
        return view('admin.users.edit', compact('user'));
    }

    public function update(UserRequest $request, User $user) {

        $this->authorize('edit_users', $user);
        if ( isset($request->photo) && $request->photo ){
            @unlink(public_path('uploads/users/') . $user->image);
            $upload_file = $request->file('photo');
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $request['height']=$height;
            $request['width']=$width;
            $request['image'] = UploadImage($request->file('photo'), 'users', '/uploads/users');
        }
        $data = $user->update($request->all());


        return $data ?
            redirect()->route('admin.users.index')->with('success', trans('messages.updateOK')) :
            redirect()->route('admin.users.index')->with('warning', trans('messages.updateNO'));
    }

    public function destroy(Request $request) {

        $data = User::find($request->id);
        @unlink(public_path('uploads/users/') . $data->image);
        $deleted = $data->delete();
        $url = route('admin.users.index');

        return $deleted
            ? json_encode(['code' => '1', 'url' => $url])
            : json_encode(['code' => '0', 'message' => 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
    public function changeStatus(Request $request){

        $updated = User::where('id', $request->id)->update(['active' => $request->status]);
        if ($request->status == 0){
            Auth::guard('web')->setUser(User::find($request->id));
            Auth::guard('web')->logout(User::find($request->id));
        }
        $url = route('admin.users.index');

        return $updated
            ? json_encode(['code'=> '1', 'url'=> $url])
            : json_encode(['code'=> '0', 'message'=> 'نأسف لحدوث هذا الخطأ, برجاء المحاولة لاحقًا']);
    }
    public function showChangePasswordForm(User $user) {

        return view('admin.users.change_password', compact('user'));
    }

    public function updatePassword(Request $request, User $user) {

        $request->validate([
            'new_password'      => 'required|min:3|max:191',
            'password_confirm'  => 'same:new_password',
        ]);

        $updated = $user->update(['password' => $request->new_password]);
        return $updated ?
            redirect()->route('admin.users.index')->with('success', 'تم تغيير كلمة مرور العضو بنجاح') :
            redirect()->route('admin.users.index')->with('warning', 'حدث خطأ ما, برجاء المحاولة مرة اخرى');
    }
}
