<?php

namespace App\Http\Controllers\Api;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App;
use Auth;
use App\Models\User;
use App\Models\UserDevice;
use App\Models\PhoneVerification;
use App\Http\Requests\Api\CheckPhoneRequest;
use App\Http\Requests\Api\CheckSendCodePhoneRequest ;
use App\Http\Requests\Api\ConfirmPhoneRequest ;
use App\Http\Resources\LoginResource;
use App\Http\Requests\Api\RegisterRequest ;
use App\Http\Requests\Api\LoginRequest ;
use App\Http\Requests\Api\LogoutRequest ;
use App\Http\Requests\Api\CheckPhoneForgetPassRequest ;
use App\Http\Requests\Api\ConfirmPhoneForgetPasswordRequest ;
use App\Http\Requests\Api\ResetPasswordRequest ;
use Tymon\JWTAuth\Facades\JWTAuth;

class AuthController extends Controller
{
    /*alaa*/

    public function check_phone(CheckPhoneRequest $request)
    {

        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        $phone =User::where('phone','05'.$phone_number)->first();
        if ($phone){
            $errorsLogin = trans('messages.phone_exist');
            return ApiController::respondWithError($errorsLogin);
        }
        $request['code']=1111;
        $request['phone']='05'.$phone_number;
        $created= PhoneVerification::create($request->all());
        $this->send_sms($created);
        return  response()->json(['mainCode'=> 1,'code' =>  http_response_code()])->setStatusCode(200);

    }

    public function send_code(CheckSendCodePhoneRequest $request)
    {
        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        $phone =User::where('phone','05'.$phone_number)->first();
        if ($phone){
            $errorsLogin = trans('messages.phone_exist');
            return ApiController::respondWithError($errorsLogin);
        }
//        $code = mt_rand(1000, 9999);
        $request['code']=1111;
        $request['phone']='05'.$phone_number;
        $updated= PhoneVerification::create($request->all());
//        $this->send_sms($updated,$request->signatures);

        return $updated
            ? response()->json(['mainCode'=> 1,'code' =>  http_response_code()])->setStatusCode(200)
            : ApiController::respondWithServerError();

    }

    public function confirmPhone(ConfirmPhoneRequest $request) {

        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        $phone =User::where('phone','05'.$phone_number)->first();
        if ($phone){
            $errorsLogin = trans('messages.phone_exist');
            return ApiController::respondWithError($errorsLogin);
        }
        $checkPhone =PhoneVerification::where('phone','05'.$phone_number)->latest('id')->first();
        if (!$checkPhone){
            $errorsLogin = trans('messages.error_phone');
            return ApiController::respondWithErrorClient($errorsLogin);
        }
        $check = PhoneVerification::where('id',$checkPhone->id)->where('code',$request->code)->latest('id')->first();
        if ($check){
             return   response()->json(['mainCode'=> 1,'code' =>  http_response_code()])->setStatusCode(200);
        }

        return  ApiController::respondWithError(trans('messages.error_code'));

    }

    /* register*/
    public function register(RegisterRequest $request) {
        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        $phone =User::where('phone','05'.$phone_number)->first();
        if ($phone){
            $errorsLogin = trans('messages.phone_exist');
            return ApiController::respondWithError($errorsLogin);
        }
        $phone = PhoneVerification::where('phone','05'.$phone_number)->orderBy('id','desc')->first();

        if ( $phone == null){
            $error = trans('messages.your_phone_or_email_doesnt_match_confirm_page');
            return  ApiController::respondWithError($error);
        }

        $user = User::create([
            'phone'                 => '05'.$phone_number,
            'name'                  => $request->name,
            'email'                  => $request->email,
            'language'            => app()->getLocale() ,
            'active'            => true,
            'approved'            => $request->user_type == "dealer" ? false : true,
            'device_token'          => $request->device_token,
            'device_identifier'           => $request->device_identifier,
            'password'              => $request->password,
            'user_type'              => $request->user_type,

        ]);
        if ($request->user_type == "dealer"){
            $regions = $request->regions;
            if ($regions == null){
                return ApiController::respondWithError(trans('messages.region_required'));
            }
            $user->regions()->sync( $regions );
            $success = trans('messages.The_registration_request');
            return ApiController::respondWithSuccessMessage($success);
        }

        $token = generateApiToken($user);
        //save_device_token....
        $created = ApiController::createUserDeviceToken($user->id, $request->device_token, $request->device_identifier);

        PhoneVerification::where('phone',$request->phone)->delete();
        $data = new LoginResource($user,$token);
        return $user
            ? ApiController::respondWithSuccess($data)
            : ApiController::respondWithServerError();


    }
    /*end  register */
    public function login(LoginRequest $request){

        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        if (Auth::attempt(['phone' => '05'.$phone_number, 'password' => $request->password, 'user_type'=>$request->user_type])) {

            if (Auth::user()->active == 0){
                $errors = trans('messages.Sorry_your_membership_was_stopped_by_Management');
                return ApiController::respondWithError($errors);
            }
            if (Auth::user()->approved == 0){
                $errors = trans('messages.The_registration_request');
                return ApiController::respondWithError($errors);
            }
            //save_device_token....
            $created = ApiController::createUserDeviceToken(Auth::user()->id, $request->device_token, $request->device_identifier);

            $token = generateApiToken(Auth::user());
            if ($request->user_type == "user"){
                $data = new LoginResource(Auth::user(),$token);
            }else{
                $data = new App\Http\Resources\Dealer\LoginResource(Auth::user(),$token);
            }


            return $data
                ? ApiController::respondWithSuccess($data)
                : ApiController::respondWithServerError();

        }else{
            $errors = trans('messages.Wrong_credential');
            return ApiController::respondWithError($errors);
        }

    }
    public function logout(LogoutRequest $request)
    {

        if (!$user = JWTAuth::parseToken()->authenticate()) {
            return response()->json(['mainCode'=> 0, 'code' => 401,'error' => 'Token is Invalid' ],401);
        }

        $exists =UserDevice::where('user_id',$request->user()->id)->where('device_identifier',$request->device_identifier)
            ->where('firebase_token',$request->device_token)->delete();

        JWTAuth::invalidate(JWTAuth::getToken());

        return  response()->json(['mainCode'=> 1,'code' =>  http_response_code()])->setStatusCode(200);


    }

    /*forget password */
    public function forgetPassword(CheckPhoneForgetPassRequest $request) {

        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        $phone =User::where('phone','05'.$phone_number)->where('user_type',$request->user_type)->first();
        if (!$phone){
            $errorsLogin = trans('messages.not_exist_phone');
            return ApiController::respondWithError($errorsLogin);
        }
        $user = User::where('phone','05'.$phone_number)->where('user_type',$request->user_type)->first();

        if($user) {

//            $code = mt_rand(1000, 9999);
            $code = 1111;
            $updated = User::where('phone','05'.$phone_number)->where('user_type',$request->user_type)->first()->update([
                'confirm_code'=> $code,
            ]);
            $user = [
                'code'=>$code,
                'phone'=>'05'.$phone_number,
                'country_code'=>$request->country_code,
            ];
//            $this->send_sms_data($user);
            return $updated
                ? response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200)
                : ApiController::respondWithServerError();

        }

        return ApiController::respondWithError(trans('messages.not_exist_phone'));
    }
    public function resendCodeForgetPassword(CheckPhoneForgetPassRequest $request) {

        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        $phone =User::where('phone','05'.$phone_number)->where('user_type',$request->user_type)->first();
        if (!$phone){
            $errorsLogin = trans('messages.not_exist_phone');
            return ApiController::respondWithError($errorsLogin);
        }
        $user = User::where('phone','05'.$phone_number)->where('user_type',$request->user_type)->first();

        if($user) {

//            $code = mt_rand(1000, 9999);
            $code = 1111;
            $updated = User::where('phone','05'.$phone_number)->where('user_type',$request->user_type)->first()->update([
                'confirm_code'=> $code,
            ]);
            $user = [
                'code'=>$code,
                'phone'=>'05'.$phone_number,
                'country_code'=>$request->country_code,
            ];
//            $this->send_sms_data($user);
            return $updated
                ? response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200)
                : ApiController::respondWithServerError();

        }

        return ApiController::respondWithError(trans('messages.not_exist_phone'));

    }
    public function confirmCodeResetPassword(ConfirmPhoneForgetPasswordRequest $request) {
        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        $phone =User::where('phone','05'.$phone_number)->where('user_type',$request->user_type)->first();
        if (!$phone){
            $errorsLogin = trans('messages.not_exist_phone');
            return ApiController::respondWithError($errorsLogin);
        }
        $data = User::where([ ['phone', '05'.$phone_number], ['confirm_code', $request->code],['user_type', $request->user_type] ])->first();
        if ($data){
            User::where([ ['phone', '05'.$phone_number], ['confirm_code', $request->code],['user_type', $request->user_type]])
                ->update(['confirm_code'=>null]);

            return   response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200);
        }

        return  ApiController::respondWithError(trans('messages.error_code'));

    }
    public function resetPassword(ResetPasswordRequest $request) {

        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        $phone =User::where('phone','05'.$phone_number)->where('user_type',$request->user_type)->first();
        if (!$phone){
            $errorsLogin = trans('messages.not_exist_phone');
            return ApiController::respondWithError($errorsLogin);
        }
        $user = User::wherePhone('05'.$phone_number)->where('user_type',$request->user_type)->first();

        if($user) {
            $updated = $user->update(['password' => $request->password]);

            return $updated
                ? ApiController::respondWithSuccessMessage(trans('messages.Password_changed_successfully'))
                : ApiController::respondWithServerError();
        }

        return ApiController::respondWithError(trans('messages.error_phone'));
    }
    /*forget password */

    public function send_sms($data){

        $settings= App\Models\Setting::find(1);

        $client = new \GuzzleHttp\Client();
        $countryCode = 966;
        $pp = (int)$data->phone;
        $phone = $countryCode.$pp;
        $url = "$settings->sms_url?username=$settings->sms_username&password=$settings->sms_password&numbers=$phone&message=$data->code&sender=$settings->sms_sender&unicode=E&return=json";
        $res = $client->get($url);
//
        $res->getStatusCode(); // 200
        $ans=$res->getBody();


    }
}
