<?php

namespace App\Http\Controllers\Api;




use App\Http\Resources\NotificationResource;
use App\Models\Notification;
use App\Models\Room;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use JWTAuth;

class BasicController extends Controller
{
    ///*alaa*/


    public function get_unread_message(){

        $data=[
            'unread_chats_count'=> \request()->header('Authorization') && JWTAuth::parseToken()->authenticate() ?
                (int) Room::whereSenderId(JWTAuth::parseToken()->authenticate()->id)->whereHas('chats', function($q) {
                    $q->where('sender_id','!=', JWTAuth::parseToken()->authenticate()->id);
                    $q->where('seen', 0);
                })->where('seen',0)->orWhere('receiver_id',JWTAuth::parseToken()->authenticate()->id)
                    ->whereHas('chats', function($q) {
                        $q->where('sender_id','!=', JWTAuth::parseToken()->authenticate()->id);
                        $q->where('seen', 0);
                    })->where('seen',0)->count() : 0,
            'whatsapp_numbner'=>settings()->whatsapp
        ];

        return ApiController::respondWithSuccess($data);

    }
    public function listNotifications(Request $request) {
        $lang = \app()->getLocale();
        $data = Notification::Where('user_id', $request->user()->id)->select('id', 'type','notifiable_id', 'title', 'message', 'created_at','seen')->orderBy('id','desc')->paginate(10);
        Notification::Where('user_id', $request->user()->id)->select('id', 'type','notifiable_id', 'title', 'message', 'created_at')->update(['seen'=>1]);

        NotificationResource::collection($data);

        return ApiController::respondWithSuccess($data);
    }

    public function delete_Notifications( $id , Request $request) {

        $data = Notification::Where('id', $id)->where('user_id',$request->user()->id)->delete();
        return $data
            ? response()->json(['mainCode'=> 1,'code' =>  http_response_code()])->setStatusCode(200)
            : ApiController::respondWithServerError();
    }
    public function delete_all_Notifications( Request $request) {

        $data = Notification::where('user_id',$request->user()->id)->delete();
        return $data
            ? response()->json(['mainCode'=> 1,'code' =>  http_response_code()])->setStatusCode(200)
            : ApiController::respondWithServerError();
    }

}
