<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\ContactUsRequest;
use App\Models\Contact;
use App\Models\Setting;
use Illuminate\Http\Request;

class ContactController extends Controller
{
    //
    public function contact_details(){

        $contact = Setting::find(1);
        $data=[
            'whatsapp_number'=>$contact->phone,
            'instagram'=>$contact->instagram,
            'snapchat'=>$contact->snapchat,
        ];
        return ApiController::respondWithSuccess($data);
    }
    public function contactUs(ContactUsRequest $request) {

        $created = Contact::create($request->all());

        if($created)
            return response()->json(['mainCode'=> 1,'code' =>  http_response_code()])->setStatusCode(200);
        else {
            return ApiController::respondWithServerError();
        }
    }
}
