<?php

namespace App\Http\Controllers\Api\Dealer;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Dealer\AddGiftRequest;
use App\Http\Resources\ChatMessageResource;
use App\Models\Chat;
use App\Models\Product;
use App\Models\ProductImage;
use App\Models\Room;
use Illuminate\Http\Request;
use Image ;
use Illuminate\Support\Facades\File;

class GiftController extends Controller
{
    //
    public function add_gift(AddGiftRequest $request){



        if ($request->type == "edit"){
            $range = Product::withTrashed()->find($request->gift_id)->range ;
            $type = $request->type;
        }else{
            $range = $request->range;
            $type = $request->type;
        }
        $request['user_id']=$request->user()->id;
        $request['to_user']=Room::find($request->room_id)->sender_id;
        $request['range']=$range;
        $request['after_discount']=$request->price;
        $request['type']="gift";
        $created=Product::create($request->all());

        if ($type == "edit"){
            if ($request->idetodelete){
               $all_images =  ProductImage::whereProductId($request->gift_id)->whereNotIn('id',$request->idetodelete)->get();
             }else{
                $all_images =  ProductImage::whereProductId($request->gift_id)->get();
            }
                foreach ($all_images as $data){
                    $image = randNumber(4).$data->image;

                    File::copy( public_path( '/uploads/products/' . $data->image ), public_path( '/uploads/products/' . $image ));

                    $file = new ProductImage();
                    $file->product_id = $created->id;
                    $file->image = $image;
                    $file->height = $data->height;
                    $file->width = $data->width;
                    $file->save();
                }

        }else{
            if ($request->idetodelete){
                $all_images =  ProductImage::whereIn('id',$request->idetodelete)->get();
                foreach ($all_images as $data){
                    @unlink(public_path('uploads/sliders/') . $data->image);
                    $data->delete();
                }
            }
        }

        if ( isset($request->photos) && $request->photos ){

            foreach ($request->photos as $data){
                $upload_file =$data;
                $height = Image::make($upload_file)->height();
                $width = Image::make($upload_file)->width();
                $image = UploadImage($data, 'products', '/uploads/products');
                $file = new ProductImage();
                $file->product_id = $created->id;
                $file->image = $image;
                $file->height = $height;
                $file->width = $width;
                $file->save();
            }
        }
       $chat = Chat::create([
            'sender_id'=>$request->user()->id,
            'senderable_type'=>"dealer",
            'room_id'=>$request->room_id,
            'gift_id'=>$created->id,
            'giftable_type'=>"App\Gift",
            'type'=>"gift",
        ]);


        $params=[
            'room_id'=>$request->room_id,
            'message_id'=>$chat->id,

        ];
        $url= 'https://nosq.app/edit-gift';
        $postData = http_build_query($params);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close ($ch);

        return response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200);




    }
    public function edit_gift(Request $request){
        $room = Room::find($request->room_id);
        $chat =  Chat::find($request->message_id);
        $data=  new ChatMessageResource($chat);
        return response()->json(['data'=>$data],200);
    }
}
