<?php

namespace App\Http\Controllers\Api\Dealer;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Dealer\OrderStatusRequest;
use App\Http\Resources\ChatMessageResource;
use App\Http\Resources\Dealer\OrdersResource;
use App\Http\Resources\Dealer\OrderDetailsResource;
use App\Models\Chat;
use App\Models\Order;
use App\Models\OrderProduct;
use App\Models\OrderTransfer;
use App\Models\PaymentMethod;
use App\Models\Product;
use App\Models\Role;
use App\Models\Room;
use App\Models\User;
use Facade\FlareClient\Api;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    //
    public function my_orders(Request  $request){
        $status = $request->status == "done" ? ['done','cancel_order'] : [$request->status];

        $orders = Order::whereIn('status',$status)->whereHas('products',function ($q){
            $q->whereHas('products',function ($q2){
                $q2->where('user_id',\request()->user()->id);
            });
        })->orderBy('id','desc')->paginate(10);
        OrdersResource::collection($orders);
        return ApiController::respondWithSuccess($orders);
    }
    public function my_orders_details($id){
        $data = Order::find($id);
        if (! $data){
            return ApiController::respondWithServerError();
        }
        $order = new OrderDetailsResource($data);
        return ApiController::respondWithSuccess($order);
    }
    public function change_order_status(OrderStatusRequest $request){
        $order = Order::find($request->order_id);
        if ($order->status == "in_progress"){

            $order->update(['status'=>"done"]);
            if (PaymentMethod::find($order->payment_method)->type == "visa"||
                PaymentMethod::find($order->payment_method)->type == "transfer"){
                $product = OrderProduct::whereOrderId($order->id)->first()->product_id;
                $user = User::find(Product::find($product)->user_id);
                $total =  $order->all_total - ($order->all_total * $user->app_percentage /100);
                $user->update(['wallet'=>$user->wallet + $total]);
            }
        }elseif ($order->status == "new"){
            $type=PaymentMethod::find($order->payment_method);
            if ($type->type == "transfer"){
                if (OrderTransfer::whereOrderId($request->order_id)->first()->status == "waiting" ||
                    OrderTransfer::whereOrderId($request->order_id)->first()->status == "refuse"){
                    return ApiController::respondWithError(trans('messages.cant_order_until_accept_transfer'));
                }
            }
            $order->update(['status'=>"in_progress"]);
        }
        return response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200);

    }
    public function chat_from_order($id){
        $data = Order::find($id);
        if (! $data){
            return ApiController::respondWithServerError();
        }
        $room = Room::where('sender_id',$data->user_id)->where('receiver_id',\request()->user()->id)->first();
        $chat=Chat::where('room_id',$room->id)->orderBy('id','desc')->paginate(10);
        ChatMessageResource::collection($chat);

        //update chat messages to seen
        Chat::where('room_id',$id)->where('seen',0)->where('sender_id','!=',\request()->user()->id)->update(['seen'=>1]);
        return ApiController::respondWithSuccess($chat);
    }
}
