<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\User\FavoriteRequest;
use App\Http\Resources\User\FavoriteResource;
use App\Models\Favorite;
use App\Models\Product;
use Illuminate\Http\Request;

class FavoriteController extends Controller
{
    //
    public function toggle_product_to_favorite(FavoriteRequest $request){


        if(Favorite::whereProductId($request->product_id)->whereUserId($request->user()->id)->count() > 0) {
            $delete = Favorite::whereProductId($request->product_id)->whereUserId($request->user()->id)->delete();
            return $delete
                ? response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200)
                : ApiController::respondWithServerError();
        }

        $favorite = Favorite::create([
            'user_id'=>$request->user()->id,
            'product_id'=>$request->product_id,
        ]);



        return $favorite
            ? response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200)
            : ApiController::respondWithServerError();
    }
    public function my_favorites(Request $request){

        $allIds = $request->user()->favorites()->pluck('product_id')->toArray();
        $data = Product::whereIn('id',$allIds)->paginate(10);
        FavoriteResource::collection($data);
        return ApiController::respondWithSuccess($data);

    }
}
