<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\User\OrderRequest;
use App\Http\Resources\User\OrderDetailsResource;
use App\Http\Resources\User\OrdersResource;
use App\Models\Order;
use App\Models\OrderTransfer;
use App\Models\PaymentMethod;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    //
    public function my_orders(){
        $data = \request()->user()->orders()->orderBy('id','desc')->paginate(10);
        OrdersResource::collection($data);
        return ApiController::respondWithSuccess($data);
    }
    public function my_order_details($id){
        $data = Order::find($id);
        if (! $data){
            return ApiController::respondWithServerError();
        }
        $order = new OrderDetailsResource($data);
        return ApiController::respondWithSuccess($order);

    }
    public function cancel_order(OrderRequest $request){
        $data = Order::find($request->order_id);
        if ($data->status == "new"){
            $data->update(['status'=>"cancel_order"]);
            $type=PaymentMethod::find($data->payment_method);
            if ($type->type == "visa" || $type->type == "transfer"){

                $data =[
                    'status'=>PaymentMethod::find($data->payment_method)->type,
                    'message'=>settings()->contact_with_admin[app()->getLocale()]
                ];
            }else{
                $data =[
                    'status'=>PaymentMethod::find($data->payment_method)->type
                ];
            }


            return ApiController::respondWithSuccess($data);

        }else{
            return ApiController::respondWithError(trans('messages.cant_order'));
        }

    }
}
