<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\User\AddOrderRequest;
use App\Http\Resources\OrderDetailsResource;
use App\Models\Cart;
use App\Models\Coupon;
use App\Models\Order;
use App\Models\OrderProduct;
use App\Models\OrderTransfer;
use App\Models\PaymentMethod;
use App\Models\Product;
use App\Models\Region;
use App\Models\User;
use App\Models\UserCoupon;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Validator;

class PaymentController extends Controller
{
    public function payment_methods(Request $request){

        $data = PaymentMethod::whereStatus(1)->get();
        $data->map(function ($method)  {
            $method['name']=$method->name[app()->getLocale()];
            $method['image_path']= '/uploads/paymentMethods/';
            $method['icon']= $method->icon;
            return $method;
        });
        $data->makeHidden(['created_at','updated_at','country_id','status','method','currency'])->toArray();
        return ApiController::respondWithSuccess($data);
    }
    public function payment_summary(Request $request){

        $carts = Cart::whereUserId($request->user()->id)->get();
        if (Cart::whereUserId($request->user()->id)->whereRange('inside')->count() > 0){
            $shipping_cost = Region::find(Cart::whereUserId($request->user()->id)->first()->region_id)->shipping_cost;
        }else{
            $shipping_cost = settings()->outside_price;
        }
        if ($request->coupon){
            $data= $this->check_add_coupon($request);

            if ($data == 1){
                $coupon = Coupon::where('code',$request->coupon)->first();;
                $total = Cart::where(['user_id' => $request->user()->id])->sum('total');
                $total_after_coupon = $coupon ? $total * $coupon->percentage /100 : null;
                $data=[
                    'total'=>$total,
                    'shipping_cost'=>$shipping_cost,
                    'total_after_coupon'=>$total_after_coupon,
                ];
                return  ApiController::respondWithSuccess($data);
            }
        }


        $total = Cart::where(['user_id' => $request->user()->id])->sum('total');
        $total_after_coupon =  0;

        $data=[
            'total'=>$total,
            'shipping_cost'=>$shipping_cost,
            'total_after_coupon'=>$total_after_coupon,
        ];
        return  ApiController::respondWithSuccess($data);
    }
    public function add_order(AddOrderRequest $request){

        if (Cart::where(['user_id' =>$request->user()->id])->count() == 0){
            return ApiController::respondWithError( trans('web.empty_cart'));
        }
        $counts = Product::whereIn('id',Cart::where(['user_id' =>$request->user()->id])->whereRange('inside')->get()->pluck('product_id')->toArray())->WhereHas('user',function ($q) use ($request){
            $q->whereHas('regions',function ($q2) use ($request){
                $q2->where('region_id',$request->region_id);
            });
        })->count();
        if (count(Cart::where(['user_id' =>$request->user()->id])->whereRange('inside')->get()->pluck('product_id')->toArray()) > 0){
            if ($counts == 0){
                return ApiController::respondWithErrorCart(trans('messages.cant_continue'));
            }
        }

//        if ($request->user()->carts()->where('region_id',$request->region_id)->where('city_id',$request->city_id)->count() == 0){
//            return ApiController::respondWithErrorCart(trans('messages.cant_continue'));
//        }
        $payment_method = PaymentMethod::find($request->payment_method);
        if ( $payment_method->type  == "cash" ){
            $carts = $request->user()->carts()->get();
            foreach ($carts as $cart){
                $productName = Product::find($cart->product_id);
                $productName->update(['sold'=>$productName->sold +1]);

            }
            $request['user_id'] = $request->user()->id;


            $request['status']="new";
            $request['payment_method']=$request->payment_method;

            if ($request->coupon){
                $data= $this->check_add_coupon($request);
                if ($data == 1){
                    $coupon = Coupon::where('code',$request->coupon)->first();
                    if($user =UserCoupon::where('coupon_id',$coupon->id)->whereUserId($request->user()->id)->first()){
                        $user->update(['used_number'=>1]);
                        Coupon::where('code',$request->coupon)->first()->update(['available_number'=> $coupon->available_number - 1]);
                        Cart::where(['user_id' => $request->user()->id])->update(['coupon'=>$coupon->percentage ,'coupon_id'=>$coupon->id]);
                    }else{
                        UserCoupon::create([
                            'user_id'=>$request->user()->id,
                            'coupon_id'=>$coupon->id,
                            'used_number'=>1,
                        ]);
                        Coupon::where('code',$request->coupon)->first()->update(['available_number'=> $coupon->available_number - 1]);
                        Cart::where(['user_id' => $request->user()->id])->update(['coupon'=>$coupon->percentage ,'coupon_id'=>$coupon->id]);
                    }

                    $request['coupon']=$coupon->percentage;
                }else{
                    $request['coupon']=null;
                }

            }else{
                $request['coupon']=null;
            }


            /*all totals */
            $coupon = isset($coupon) ? $coupon->percentage : null;
            $total = Cart::where(['user_id' => $request->user()->id])->sum('total');
            $total_after_coupon = $coupon ? $total * $coupon /100: 0;
            if (Cart::whereUserId($request->user()->id)->whereRange('inside')->count() > 0){
                $shipping_cost = Region::find(Cart::whereUserId($request->user()->id)->first()->region_id)->shipping_cost;
            }else{
                $shipping_cost = settings()->outside_price;
            }

            $request['shipping_cost']=$shipping_cost;
            $request['products_total']=$total;
            $request['total_after_coupon']= $total_after_coupon;
            $request['all_total']= ($total + $shipping_cost) - $total_after_coupon ;

            $order = Order::create($request->all());
            foreach ($carts as $data){
                OrderProduct::create([
                    'order_id'=>$order->id,
                    'product_id'=>$data->product_id,
                    'productable_type'=>$data->productable_type,
                    'price'=>$data->price,
                ]);
            }

            /*notifications */
            $notificationTitle = array(
                'ar'=>'طلب جديد',
                'en'=>'New Order',
            );
            $notificationMessage = array(
                'ar'=>'طلب جديد'.$order->id,
                'en'=>'New Order '.$order->id,

            );
            $user_id = Product::whereIn('id',Cart::where(['user_id' =>$request->user()->id])->get()->pluck('product_id')->toArray())->first()->user_id;
            sendMobileNotification($user_id,$notificationTitle,$notificationMessage,3,$order->id);
            saveOrderNotification($user_id, 3, serialize($notificationTitle), serialize($notificationMessage),$order->id,
                'App\Order');

            /*end notification*/
            Cart::where('user_id',$request->user()->id)->delete();


            $data = new OrderDetailsResource($order);
            return ApiController::respondWithSuccess($data);

        }
        elseif ( $payment_method->type  == "transfer" ){
            $rules = [
                'bank_id'          => 'required|exists:banks,id',
                'bank_name'           => 'required',
                'user_name'           => 'required',
                'account_number'           => 'required',
                'balance'           => 'required|numeric',
                'photo'           => 'required|mimes:jpg,gif,jpeg,png,tiff,svg',

            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails())
                return ApiController::respondWithError(validateRules($validator->errors(), $rules));
            $carts = $request->user()->carts()->get();
            foreach ($carts as $cart){
                $productName = Product::find($cart->product_id);
                $productName->update(['sold'=>$productName->sold +1]);

            }
            $request['user_id'] = $request->user()->id;


            $request['status']="new";
            $request['payment_method']=$request->payment_method;

            if ($request->coupon){
                $data= $this->check_add_coupon($request);
                if ($data == 1){
                    $coupon = Coupon::where('code',$request->coupon)->first();
                    if($user =UserCoupon::where('coupon_id',$coupon->id)->whereUserId($request->user()->id)->first()){
                        $user->update(['used_number'=>1]);
                        Coupon::where('code',$request->coupon)->first()->update(['available_number'=> $coupon->available_number - 1]);
                        Cart::where(['user_id' => $request->user()->id])->update(['coupon'=>$coupon->percentage ,'coupon_id'=>$coupon->id]);
                    }else{
                        UserCoupon::create([
                            'user_id'=>$request->user()->id,
                            'coupon_id'=>$coupon->id,
                            'used_number'=>1,
                        ]);
                        Coupon::where('code',$request->coupon)->first()->update(['available_number'=> $coupon->available_number - 1]);
                        Cart::where(['user_id' => $request->user()->id])->update(['coupon'=>$coupon->percentage ,'coupon_id'=>$coupon->id]);
                    }

                    $request['coupon']=$coupon->percentage;
                }else{
                    $request['coupon']=null;
                }

            }else{
                $request['coupon']=null;
            }


            /*all totals */
            $coupon = isset($coupon) ? $coupon->percentage : null;
            $total = Cart::where(['user_id' => $request->user()->id])->sum('total');
            $total_after_coupon = $coupon ? $total * $coupon /100: 0;
            if (Cart::whereUserId($request->user()->id)->whereRange('inside')->count() > 0){
                $shipping_cost = Region::find(Cart::whereUserId($request->user()->id)->first()->region_id)->shipping_cost;
            }else{
                $shipping_cost = settings()->outside_price;
            }

            $request['shipping_cost']=$shipping_cost;
            $request['products_total']=$total;
            $request['total_after_coupon']= $total_after_coupon;
            $request['all_total']= ($total + $shipping_cost) - $total_after_coupon ;

            $order = Order::create($request->all());
            OrderTransfer::create([
                'order_id'=>$order->id,
                'bank_id'=>$request->bank_id,
                'bank_name'=>$request->bank_name,
                'user_name'=>$request->user_name,
                'image'=>UploadImage($request->photo, 'transfers', '/uploads/transfers'),
                'account_number'=>$request->account_number,
                'balance'=>$request->balance,
            ]);
            foreach ($carts as $data){
                OrderProduct::create([
                    'order_id'=>$order->id,
                    'product_id'=>$data->product_id,
                    'productable_type'=>$data->productable_type,
                    'price'=>$data->price,
                ]);
            }

            /*notifications */
            $notificationTitle = array(
                'ar'=>'طلب جديد',
                'en'=>'New Order',
            );
            $notificationMessage = array(
                'ar'=>'طلب جديد'.$order->id,
                'en'=>'New Order '.$order->id,

            );
            $user_id = Product::whereIn('id',Cart::where(['user_id' =>$request->user()->id])->get()->pluck('product_id')->toArray())->first()->user_id;
            sendMobileNotification($user_id,$notificationTitle,$notificationMessage,3,$order->id);
            saveOrderNotification($user_id, 3, serialize($notificationTitle), serialize($notificationMessage),$order->id,
                'App\Order');

            /*end notification*/
            Cart::where('user_id',$request->user()->id)->delete();


            $data = new OrderDetailsResource($order);
            return ApiController::respondWithSuccess($data);

        }
        elseif ($payment_method->type == "visa"){
            /*all totals */
            if ($request->coupon){
                $data= $this->check_add_coupon($request);
                if ($data == 1){
                    $coupon = Coupon::where('code',$request->coupon)->first();
                    Cart::where(['user_id' => $request->user()->id])->update(['coupon'=>$coupon->percentage ,'coupon_id'=>$coupon->id]);
                }else{
                    $request['coupon']=null;
                }


            }else{
                $request['coupon']=null;
            }
            $coupon = Cart::where(['user_id' => $request->user()->id])->first();
            $total = Cart::where(['user_id' => $request->user()->id])->sum('total');
            $total_after_coupon = $coupon->coupon ? $total * $coupon->coupon /100 : 0;

            if (Cart::whereUserId($request->user()->id)->whereRange('inside')->count() > 0){
                $shipping_cost = Region::find(Cart::whereUserId($request->user()->id)->first()->region_id)->shipping_cost;
            }else{
                $shipping_cost = settings()->outside_price;
            }

            $request['shipping_cost']=$shipping_cost;


            $amount = $total - $total_after_coupon +$shipping_cost;
            $des = "Payment Order";
            $curl = curl_init();
            $url=url('/');
            $user= $request->user();
            $lang = app()->getLocale();
            //SAR
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://api.tap.company/v2/charges",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => "{\"amount\":$amount,\"currency\":\"$payment_method->currency\",\"threeDSecure\":true,\"save_card\":false,\"description\":\"$des\",\"statement_descriptor\":\"Sample\",\"metadata\":{\"user_id\":\"$user->id\",\"payment_method\":\"$request->payment_method\",\"name\":\"$request->name\",\"phone\":\"$request->phone\",\"notes\":\"$request->notes\",\"region_id\":\"$request->region_id\",\"city_id\":\"$request->city_id\"},\"reference\":{\"transaction\":\"txn_0001\",\"order\":\"ord_0001\"},\"receipt\":{\"email\":false,\"sms\":true},\"customer\":{\"first_name\":\"$user->name\",\"middle_name\":\"''\",\"last_name\":\"''\",\"email\":\"$user->email\",\"phone\":{\"country_code\":\"+966\",\"number\":\"$user->phone\"}},\"source\":{\"id\":\"$payment_method->method\"},\"post\":{\"url\":\"http://your_website.com/post_url\"},\"redirect\":{\"url\":\"$url/redirect_url?lang=$lang\"}}",
                CURLOPT_HTTPHEADER => array(
                    "authorization: Bearer sk_test_vGwkpL7RYPJeU8WOIobZzmDy",
                    "content-type: application/json"
                ),
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);
//            dd($response);
            curl_close($curl);


            if ($err) {
                return '"cURL Error #:" . $err';
            } else {
                $in = json_decode($response, true);
                // transaction
                $link = $in['transaction']['url'];
                $data=[
                    'payment_url'=>$link
                ];
                return ApiController::respondWithSuccess($data);

            }

        }

    }
    public function payment_type(Request $request)
    {
        $key = $request->get('tap_id');
        $lang = $request->get('lang');

        \App::setLocale($lang);

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.tap.company/v2/charges/$key",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_POSTFIELDS => "{}",
            CURLOPT_HTTPHEADER => array(
                "authorization: Bearer sk_test_vGwkpL7RYPJeU8WOIobZzmDy"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        }
        else {
            $status = array(
                '000' => \Lang::get('data.000'),
                '001' => \Lang::get('data.001'),
                '100' => \Lang::get('data.100'),
                '200' => \Lang::get('data.200'),
                '301' => \Lang::get('data.301'),
                '302' => \Lang::get('data.302'),
                '303' => \Lang::get('data.303'),
                '304' => \Lang::get('data.304'),
                '401' => \Lang::get('data.401'),
                '402' => \Lang::get('data.402'),
                '403' => \Lang::get('data.403'),
                '404' => \Lang::get('data.404'),
                '405' => \Lang::get('data.405'),
                '406' => \Lang::get('data.406'),
                '407' => \Lang::get('data.407'),
                '408' => \Lang::get('data.408'),
                '501' => \Lang::get('data.501'),
                '502' => \Lang::get('data.502'),
                '503' => \Lang::get('data.503'),
                '504' => \Lang::get('data.504'),
                '505' => \Lang::get('data.505'),
                '506' => \Lang::get('data.506'),
                '507' => \Lang::get('data.507'),
                '508' => \Lang::get('data.508'),
                '509' => \Lang::get('data.509'),
                '510' => \Lang::get('data.510'),
                '511' => \Lang::get('data.511'),
                '512' => \Lang::get('data.512'),
                '513' => \Lang::get('data.513'),
                '514' => \Lang::get('data.514'),
                '515' => \Lang::get('data.515'),
                '601' => \Lang::get('data.601'),
                '701' => \Lang::get('data.701'),
                '702' => \Lang::get('data.702'),
                '703' => \Lang::get('data.703'),
                '704' => \Lang::get('data.704'),
                '801' => \Lang::get('data.801'),
                '901' => \Lang::get('data.901'),
            );
            $in = json_decode($response, true);
            // transaction


            if (isset($in['errors'])){
                $status = $in['errors'][0]['description'];
//                $code = $in['errors'][0]['code'];
                $payment = ['success'=> 0 , 'order_id' => 0 ,'error'=>$status];
                $payments = collect([]);
                $payments = $payments->push($payment);
                return "<script type=text/javascript>
                      PrintPayment.postMessage('$payments');
                     </script>";
//                return view('payment.payment', compact('status','code','success')) ;

            }else{
                $user_id = $in['metadata']['user_id'];
                $amount = $in['amount'];
                $user=User::find($user_id);


                if ($in["response"]['code'] == 000) {

                    if (Cart::where(['user_id' =>$user->id])->count() == 0){
                        $status = $status[$in["response"]['code']];
                        $code = $in["response"]['code'];
                        $payment = ['success'=> 0 , 'order_id' => 0 ,'error'=>trans('web.empty_cart')];
                        $payments = collect([]);
                        $payments = $payments->push($payment);
                        return "<script type=text/javascript>
                                  PrintPayment.postMessage('$payments');
                                 </script>";
                    }
                    $carts = $user->carts()->get();
                    foreach ($carts as $cart){

                        $productName = Product::find($cart->product_id);

                        $productName->update([ 'sold' => $productName->sold + 1]);


                    }

                    $request['user_id'] = $user->id;
                    $request['name']=$in['metadata']['name'];;
                    $request['phone']=$in['metadata']['phone'];;
                    $request['notes']=$in['metadata']['notes'];;
                    $request['region_id']=$in['metadata']['region_id'];;
                    $request['city_id']=$in['metadata']['city_id'];;

                    $request['status']="new";
                    $request['payment_method']=$in['metadata']['payment_method'];

                    if ($cart =Cart::where('user_id', $user->id)->first()->coupon_id){
                        $coupon = Coupon::find($cart);
                        if($user1 =UserCoupon::where('coupon_id',$coupon->id)->whereUserId($user->id)->first()){
                            $user1->update(['used_number'=>1]);
                            Coupon::find($cart)->update(['available_number'=> $coupon->available_number - 1]);

                        }else{
                            UserCoupon::create([
                                'user_id'=>$user->id,
                                'coupon_id'=>$coupon->id,
                                'used_number'=>1,
                            ]);
                            Coupon::find($cart->coupon_id)->update(['available_number'=> $coupon->available_number - 1]);
                        }

                        $request['coupon']=$coupon->percentage;
                    }
                    $request['transaction_id']=$request->get('tap_id');


                    /*all totals */
                    $coupon = Cart::where(['user_id' => $user->id])->first();
                    $total = Cart::where(['user_id' => $user->id])->sum('total');
                    $total_after_coupon = $coupon->coupon ? $total * $coupon->coupon /100 : 0;
                    if (Cart::whereUserId($user->id)->whereRange('inside')->count() > 0){
                        $shipping_cost = Region::find(Cart::whereUserId($user->id)->first()->region_id)->shipping_cost;
                    }else{
                        $shipping_cost = settings()->outside_price;
                    }



                    $request['shipping_cost']=$shipping_cost;
                    $request['products_total']=$total;
                    $request['total_after_coupon']=$total_after_coupon;
                    $request['all_total']= ($total + $shipping_cost) - $total_after_coupon ;

                    $order = Order::create($request->all());
                    foreach ($carts as $data){
                        OrderProduct::create([
                            'order_id'=>$order->id,
                            'product_id'=>$data->product_id,
                            'productable_type'=>$data->productable_type,
                            'price'=>$data->price,
                        ]);
                    }

                    /*notifications */
                    $notificationTitle = array(
                        'ar'=>'طلب جديد',
                        'en'=>'New Order',
                    );
                    $notificationMessage = array(
                        'ar'=>'طلب جديد'.$order->id,
                        'en'=>'New Order '.$order->id,

                    );
                    $user_id = Product::whereIn('id',Cart::where(['user_id' =>$user->id])->get()->pluck('product_id')->toArray())->first()->user_id;
                    sendMobileNotification($user_id,$notificationTitle,$notificationMessage,3,$order->id);
                    saveOrderNotification($user_id, 3, serialize($notificationTitle), serialize($notificationMessage),$order->id,
                        'App\Order');

                    /*end notification*/

                    Cart::where('user_id',$user->id)->delete();



                    $status = $status[$in["response"]['code']];
                    $code = $in["response"]['code'];
                    $payment = ['success'=> 1 , 'order_id' => $order->id];
                    $payments = collect([]);
                    $payments = $payments->push($payment);
                    return "<script type=text/javascript>
                      PrintPayment.postMessage('$payments');
                     </script>";

                }
                $status = $status[$in["response"]['code']];
                $code = $in["response"]['code'];
                $payment = ['success'=> 0 , 'order_id' => 0,'error'=>$status];
                $payments = collect([]);
                $payments = $payments->push($payment);
                return "<script type=text/javascript>
                      PrintPayment.postMessage('$payments');
                     </script>";
            }


//            return $in['amount'];
        }


    }

    public function add_coupon( Request $request){

        if (Cart::where(['user_id' => $request->user()->id])->count() == 0){
            return ApiController::respondWithErrorClient(trans('web.empty_cart'));
        }

        $rules = [
            'coupon'     => 'required',
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails())
            return ApiController::respondWithErrorClient(validateRules($validator->errors(), $rules));

        $coupon = Coupon::where('code',$request->coupon)->first();
        // to check if the coupon is active or not
        if ($coupon != null && $coupon->status == 0){
            return ApiController::respondWithErrorClient(trans('web.deactivate_coupon'));

        }
        if ($coupon != null && $coupon->from_date !== null){
            /*all totals */

            $total = Cart::where(['user_id' => $request->user()->id])->sum('total');
            $total_after_coupon = $coupon->percentage ? $total * $coupon->percentage /100 : null;
            if (Cart::whereUserId($request->user()->id)->whereRange('inside')->count() > 0){
                $shipping_cost = Region::find(Cart::whereUserId($request->user()->id)->first()->region_id)->shipping_cost;
            }else{
                $shipping_cost = settings()->outside_price;
            }
            $data=[
                'total'=>$total,
                'total_after_coupon'=>$total_after_coupon,
                'shipping_cost'=>$shipping_cost,
            ];
            if (($coupon->from_date <= Carbon::now()->format('Y-m-d') && $coupon->to_date >= Carbon::now()->format('Y-m-d') )){

                if ($coupon->shared == 1){
                    if ($coupon->available_number > 0){
                        if ($user =UserCoupon::where('coupon_id',$coupon->id)->whereUserId($request->user()->id)->first()){
                            if ($user->used_number == 0){
                                return ApiController::respondWithSuccess($data);
                            }else{
                                return ApiController::respondWithErrorClient(trans('web.used_coupon'));

                            }
                        }else{
                            return ApiController::respondWithSuccess($data);
                        }

                    }else{
                        return ApiController::respondWithErrorClient(trans('web.not_available_number_coupon'));
                    }

                }
                else{
                    if ($user=UserCoupon::where('coupon_id',$coupon->id)->whereUserId($request->user()->id)->first()){
                        if ($user->used_number == 0){
                            return ApiController::respondWithSuccess($data);
                        }else{
                            return ApiController::respondWithErrorClient(trans('web.used_coupon'));
                        }

                    }else{
                        return ApiController::respondWithErrorClient(trans('web.not_available_coupon'));
                    }
                }

            }else{
                if ($coupon->from_date > Carbon::now()->format('Y-m-d')){
                    return ApiController::respondWithErrorClient(trans('web.not_start_coupon'));
                }else{
                    return ApiController::respondWithErrorClient(trans('web.end_coupon'));
                }


            }
        }
        elseif ($coupon != null && $coupon->from_date == null){
            /*all totals */

            $total = Cart::where(['user_id' => $request->user()->id])->sum('total');
            $total_after_coupon = $coupon->percentage ? $total * $coupon->percentage /100 : null;

            $data=[
                'total'=>$total,
                'total_after_coupon'=>$total_after_coupon,
            ];
            if ($coupon->shared == 1){
                if ($coupon->available_number > 0){
                    if ($user =UserCoupon::where('coupon_id',$coupon->id)->whereUserId($request->user()->id)->first()){
                        if ($user->used_number == 0){
                            return ApiController::respondWithSuccess($data);
                        }else{
                            return ApiController::respondWithErrorClient(trans('web.used_coupon'));
                        }
                    }else{
                        return ApiController::respondWithSuccess($data);
                    }

                }else{
                    return ApiController::respondWithErrorClient(trans('web.not_available_number_coupon'));
                }

            }
            else{
                if ($user=UserCoupon::where('coupon_id',$coupon->id)->whereUserId($request->user()->id)->first()){
                    if ($user->used_number == 0){
                        return ApiController::respondWithSuccess($data);
                    }else{
                        return ApiController::respondWithErrorClient(trans('web.used_coupon'));
                    }

                }else{
                    return ApiController::respondWithErrorClient(trans('web.not_available_coupon'));
                }
            }

        }else{
            return ApiController::respondWithErrorClient(trans('web.wrong_coupon'));
        }



    }
    public function check_add_coupon( Request $request){

        if (Cart::where(['user_id' => $request->user()->id])->count() == 0){
            return 0;
        }

        $rules = [
            'coupon'     => 'required',
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails())
            return 0;

        $coupon = Coupon::where('code',$request->coupon)->first();
        // to check if the coupon is active or not
        if ($coupon != null && $coupon->status == 0){
            return 0;

        }
        if ($coupon != null && $coupon->from_date !== null){
            /*all totals */

            $total = Cart::where(['user_id' => $request->user()->id])->sum('total');
            $total_after_coupon = $coupon->percentage ? $total * $coupon->percentage /100 : null;

            $data=[
                'total'=>$total,
                'total_after_coupon'=>$total_after_coupon,
            ];
            if (($coupon->from_date <= Carbon::now()->format('Y-m-d') && $coupon->to_date >= Carbon::now()->format('Y-m-d') )){

                if ($coupon->shared == 1){
                    if ($coupon->available_number > 0){
                        if ($user =UserCoupon::where('coupon_id',$coupon->id)->whereUserId($request->user()->id)->first()){
                            if ($user->used_number == 0){
                                return 1;
                            }else{
                                return 0;

                            }
                        }else{
                            return 1;
                        }

                    }else{
                        return 0;
                    }

                }
                else{
                    if ($user=UserCoupon::where('coupon_id',$coupon->id)->whereUserId($request->user()->id)->first()){
                        if ($user->used_number == 0){
                            return 1;
                        }else{
                            return 0;
                        }

                    }else{
                        return 0;
                    }
                }

            }else{
                if ($coupon->from_date > Carbon::now()->format('Y-m-d')){
                    return 0;
                }else{
                    return 0;
                }


            }
        }
        elseif ($coupon != null && $coupon->from_date == null){
            /*all totals */

            $total = Cart::where(['user_id' => $request->user()->id])->sum('total');
            $total_after_coupon = $coupon->percentage ? $total * $coupon->percentage /100 : null;

            $data=[
                'total'=>$total,
                'total_after_coupon'=>$total_after_coupon,
            ];
            if ($coupon->shared == 1){
                if ($coupon->available_number > 0){
                    if ($user =UserCoupon::where('coupon_id',$coupon->id)->whereUserId($request->user()->id)->first()){
                        if ($user->used_number == 0){
                            return 1;
                        }else{
                            return 0;
                        }
                    }else{
                        return 1;
                    }

                }else{
                    return 0;
                }

            }
            else{
                if ($user=UserCoupon::where('coupon_id',$coupon->id)->whereUserId($request->user()->id)->first()){
                    if ($user->used_number == 0){
                        return 1;
                    }else{
                        return 0;
                    }

                }else{
                    return 0;
                }
            }

        }else{
            return 0;
        }



    }
}
