<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\ChangePasswordRequest;
use App\Http\Requests\Api\CheckPhoneRequest;
use App\Http\Requests\Api\ConfirmPhoneRequest;
use App\Http\Requests\Api\User\EditProfileRequest;
use App\Http\Resources\User\LoginResource;
use App\Models\Setting;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Tymon\JWTAuth\Facades\JWTAuth;
use Image;

class ProfileController extends Controller
{
    public function profile()
    {

        $user= JWTAuth::parseToken()->authenticate();
        $data = new LoginResource($user);
        return ApiController::respondWithSuccess($data);

    }
    public function edit_profile(EditProfileRequest $request)
    {
        if ($request->photo){
            $upload_file = $request->photo;
            $height = Image::make($upload_file)->height();
            $width = Image::make($upload_file)->width();
            $image =  UploadImage($request->photo, 'users', '/uploads/users');
        }

        $user= JWTAuth::parseToken()->authenticate();
        $user ->update([
            'email'=>$request->email ?? $user->email,
            'name'=>$request->name ?? $user->name,
            'birthday'=>$request->birthday ?? $user->birthday,
            'gender'=>$request->gender ?? $user->gender,
            'image'=>isset($image) ? $image :$user->image ,
            'height'=>isset($height) ? $height :$user->height ,
            'width'=>isset($width) ? $width :$user->width ,

        ]);
        $data = new LoginResource($user);
        return ApiController::respondWithSuccess($data);

    }
    public function changePassword(ChangePasswordRequest $request){

        if(  Hash::check($request->old_password, $request->user()->password)){

            User::find($request->user()->id)->update([
                'password'          => $request->password,
            ]);


            return ApiController::respondWithSuccessMessage(trans('messages.Password_changed_successfully'));
        }

        return ApiController::respondWithError(trans('messages.wrong_old_password'));

    }
    public function send_code_for_change_phone(CheckPhoneRequest $request)
    {
        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        $phone =User::where('phone','05'.$phone_number)->first();
        if ($phone){
            $errorsLogin = trans('messages.phone_exist');
            return ApiController::respondWithError($errorsLogin);
        }
//        $code = mt_rand(1000, 9999);
        $code = 1111;

        $updated = User::where('id',$request->user()->id)->first()->update([
            'confirm_code'=> $code,
        ]);
        $created = [
            'phone'=>'05'.$phone_number,
            'country_code'=>$request->country_code,
            'code'=>$code,
        ];

//        $this->send_sms($created);

        return $updated
            ?  response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200)
            : ApiController::respondWithServerError();

    }
    public function resendCodeChangePhone(CheckPhoneRequest $request)
    {
        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        $phone =User::where('phone','05'.$phone_number)->first();
        if ($phone){
            $errorsLogin = trans('messages.phone_exist');
            return ApiController::respondWithError($errorsLogin);
        }
//        $code = mt_rand(1000, 9999);
        $code = 1111;

        $updated = User::where('id',$request->user()->id)->first()->update([
            'confirm_code'=> $code,
        ]);
        $created = [
            'phone'=>'05'.$phone_number,
            'country_code'=>$request->country_code,
            'code'=>$code,
        ];

//        $this->send_sms($created);

        return $updated
            ?  response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200)
            : ApiController::respondWithServerError();

    }
    public function confirmCodeChangePhone(ConfirmPhoneRequest $request) {
        $phone_number= trim(substr($request->phone, strpos($request->phone, '5') + 1));

        $phone =User::where('phone','05'.$phone_number)->first();
        if ($phone){
            $errorsLogin = trans('messages.phone_exist');
            return ApiController::respondWithError($errorsLogin);
        }
        $data = User::where([ ['id', $request->user()->id], ['confirm_code', $request->code] ])->first();
        if ($data){
            User::where([ ['id', $request->user()->id], ['confirm_code', $request->code]])
                ->update(['confirm_code'=>null , 'phone'=>'05'.$phone_number ]);

            return  ApiController::respondWithSuccessMessage(trans('messages.phone_changed_successfully'));
        }

        return  ApiController::respondWithError(trans('messages.error_code'));

    }
    public function send_sms($data){

        $settings= App\Models\Setting::find(1);

        $client = new \GuzzleHttp\Client();
        $countryCode = 966;
        $ppp =(int)$data['phone'];
        $phone = $countryCode.$ppp;
        $code = $data['code'];
        $url = "$settings->sms_url?username=$settings->sms_username&password=$settings->sms_password&numbers=$phone&message=$code&sender=$settings->sms_sender&unicode=E&return=json";
        $res = $client->get($url);
//
        $res->getStatusCode(); // 200
        $ans=$res->getBody();


    }
}
