<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\User\RateRequest;
use App\Http\Resources\User\RateResource;
use App\Models\Order;
use App\Models\OrderProduct;
use App\Models\Product;
use App\Models\ProductRate;
use Illuminate\Http\Request;

class RateController extends Controller
{
    //
    public function rates($id){

        $rates = ProductRate::where('to_user',$id)->orderBy('id','desc')->paginate(10);

        RateResource::collection($rates);
        return ApiController::respondWithSuccess($rates);

    }
    public function add_rate(RateRequest $request){

        if (ProductRate::whereOrderId($request->order_id)->whereToUser(Product::find(OrderProduct::whereOrderId($request->order_id)->first()->product_id)->user_id)->count() > 0){
            return ApiController::respondWithError(trans('messages.Already_Rated_Before'));
        }
        $order = Order::find($request->order_id);
        if ($order->status != "done"){
            return ApiController::respondWithError(trans('messages.cant_rate'));
        }
        ProductRate::create([
            'order_id'=>$request->order_id,
            'user_id'=>$request->user()->id,
            'to_user'=>Product::find(OrderProduct::whereOrderId($request->order_id)->first()->product_id)->user_id,
            'rate'=>$request->rate,
            'comment'=>$request->comment,
        ]);
        return response()->json(['mainCode'=> 1,'code' =>  http_response_code()],200)->setStatusCode(200);

    }
}
